/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.persistence.filesystem;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import org.apache.flink.core.fs.FSDataOutputStream;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.persistence.RetrievableStateStorageHelper;
import org.apache.flink.runtime.state.RetrievableStateHandle;
import org.apache.flink.runtime.state.RetrievableStreamStateHandle;
import org.apache.flink.util.FileUtils;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.Preconditions;

public class FileSystemStateStorageHelper<T extends Serializable>
implements RetrievableStateStorageHelper<T> {
    private final Path rootPath;
    private final String prefix;
    private final FileSystem fs;

    public FileSystemStateStorageHelper(Path rootPath, String prefix) throws IOException {
        this.rootPath = (Path)Preconditions.checkNotNull((Object)rootPath, (String)"Root path");
        this.prefix = (String)Preconditions.checkNotNull((Object)prefix, (String)"Prefix");
        this.fs = FileSystem.get((URI)rootPath.toUri());
    }

    @Override
    public RetrievableStateHandle<T> store(T state) throws Exception {
        Exception latestException = null;
        int attempt = 0;
        while (attempt < 10) {
            RetrievableStreamStateHandle retrievableStreamStateHandle;
            block9: {
                Path filePath = this.getNewFilePath();
                FSDataOutputStream outStream = this.fs.create(filePath, FileSystem.WriteMode.NO_OVERWRITE);
                try {
                    InstantiationUtil.serializeObject((OutputStream)outStream, state);
                    retrievableStreamStateHandle = new RetrievableStreamStateHandle(filePath, outStream.getPos());
                    if (outStream == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (outStream != null) {
                            try {
                                outStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        latestException = e;
                        ++attempt;
                    }
                }
                outStream.close();
            }
            return retrievableStreamStateHandle;
        }
        throw new Exception("Could not open output stream for state backend", latestException);
    }

    private Path getNewFilePath() {
        return new Path(this.rootPath, FileUtils.getRandomFilename((String)this.prefix));
    }
}

