/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferHeader;
import org.apache.flink.runtime.io.network.buffer.BufferRecycler;
import org.apache.flink.runtime.io.network.buffer.CompositeBuffer;
import org.apache.flink.runtime.io.network.buffer.NetworkBuffer;
import org.apache.flink.runtime.io.network.partition.BufferReaderWriterUtil;
import org.apache.flink.runtime.io.network.partition.PartitionedFile;
import org.apache.flink.runtime.io.network.partition.ResultSubpartitionIndexSet;
import org.apache.flink.util.Preconditions;

class PartitionedFileReader {
    private final ByteBuffer headerBuf;
    private final ByteBuffer indexEntryBuf;
    private final PartitionedFile partitionedFile;
    private final ResultSubpartitionIndexSet subpartitionIndexSet;
    private final FileChannel dataFileChannel;
    private final FileChannel indexFileChannel;
    private final int subpartitionOrderRotationIndex;
    private int nextRegionToRead;
    private long nextOffsetToRead;
    private long currentRegionRemainingBytes;
    private final Queue<BufferPositionDescriptor> readBufferPositions = new ArrayDeque<BufferPositionDescriptor>();
    private BufferPositionDescriptor currentBufferPositionDescriptor;

    PartitionedFileReader(PartitionedFile partitionedFile, ResultSubpartitionIndexSet subpartitionIndexSet, FileChannel dataFileChannel, FileChannel indexFileChannel, ByteBuffer headerBuffer, ByteBuffer indexEntryBuffer, int subpartitionOrderRotationIndex) {
        Preconditions.checkArgument((boolean)((FileChannel)Preconditions.checkNotNull((Object)dataFileChannel)).isOpen(), (Object)"Data file channel must be opened.");
        Preconditions.checkArgument((boolean)((FileChannel)Preconditions.checkNotNull((Object)indexFileChannel)).isOpen(), (Object)"Index file channel must be opened.");
        this.partitionedFile = (PartitionedFile)Preconditions.checkNotNull((Object)partitionedFile);
        this.subpartitionIndexSet = subpartitionIndexSet;
        this.dataFileChannel = dataFileChannel;
        this.indexFileChannel = indexFileChannel;
        this.headerBuf = headerBuffer;
        this.indexEntryBuf = indexEntryBuffer;
        this.subpartitionOrderRotationIndex = subpartitionOrderRotationIndex;
    }

    private void moveToNextReadablePosition(ByteBuffer indexEntryBuf) throws IOException {
        while (this.currentRegionRemainingBytes <= 0L && this.hasNextPositionToRead()) {
            if (!this.readBufferPositions.isEmpty()) {
                BufferPositionDescriptor descriptor = this.readBufferPositions.poll();
                this.nextOffsetToRead = descriptor.offset;
                this.currentRegionRemainingBytes = descriptor.size;
                this.currentBufferPositionDescriptor = descriptor;
                continue;
            }
            if (this.nextRegionToRead >= this.partitionedFile.getNumRegions()) continue;
            this.updateReadableOffsetAndSize(indexEntryBuf, this.readBufferPositions);
            ++this.nextRegionToRead;
        }
    }

    private boolean hasNextPositionToRead() {
        return !this.readBufferPositions.isEmpty() || this.nextRegionToRead < this.partitionedFile.getNumRegions();
    }

    @VisibleForTesting
    void updateReadableOffsetAndSize(ByteBuffer indexEntryBuf, Queue<BufferPositionDescriptor> readBufferPositions) throws IOException {
        int startSubpartition = this.subpartitionIndexSet.getStartIndex();
        int endSubpartition = this.subpartitionIndexSet.getEndIndex();
        if (startSubpartition >= this.subpartitionOrderRotationIndex || endSubpartition < this.subpartitionOrderRotationIndex) {
            this.updateReadableOffsetAndSize(startSubpartition, endSubpartition, indexEntryBuf, readBufferPositions);
        } else {
            this.updateReadableOffsetAndSize(this.subpartitionOrderRotationIndex, endSubpartition, indexEntryBuf, readBufferPositions);
            this.updateReadableOffsetAndSize(startSubpartition, this.subpartitionOrderRotationIndex - 1, indexEntryBuf, readBufferPositions);
        }
    }

    private void updateReadableOffsetAndSize(int startSubpartition, int endSubpartition, ByteBuffer indexEntryBuf, Queue<BufferPositionDescriptor> readBufferPositions) throws IOException {
        this.partitionedFile.getIndexEntry(this.indexFileChannel, indexEntryBuf, this.nextRegionToRead, startSubpartition);
        long startPartitionOffset = indexEntryBuf.getLong();
        long startPartitionSize = indexEntryBuf.getLong();
        this.partitionedFile.getIndexEntry(this.indexFileChannel, indexEntryBuf, this.nextRegionToRead, endSubpartition);
        long endPartitionOffset = indexEntryBuf.getLong();
        long endPartitionSize = indexEntryBuf.getLong();
        if (startPartitionOffset != endPartitionOffset || startPartitionSize != endPartitionSize) {
            readBufferPositions.add(new BufferPositionDescriptor(startPartitionOffset, endPartitionOffset + endPartitionSize - startPartitionOffset, 1));
        } else if (startPartitionSize != 0L) {
            readBufferPositions.add(new BufferPositionDescriptor(startPartitionOffset, startPartitionSize, endSubpartition - startSubpartition + 1));
        }
    }

    @VisibleForTesting
    void readCurrentRegion(Queue<MemorySegment> freeSegments, BufferRecycler recycler, Consumer<Buffer> consumer) throws IOException {
        this.readCurrentRegion(freeSegments, recycler, (Buffer buffer, Integer repeatCount) -> consumer.accept((Buffer)buffer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean readCurrentRegion(Queue<MemorySegment> freeSegments, BufferRecycler recycler, BiConsumer<Buffer, Integer> consumer) throws IOException {
        if (this.currentRegionRemainingBytes == 0L) {
            return false;
        }
        Preconditions.checkArgument((!freeSegments.isEmpty() ? 1 : 0) != 0, (Object)"No buffer available for data reading.");
        this.dataFileChannel.position(this.nextOffsetToRead);
        BufferAndHeader partialBuffer = new BufferAndHeader(null, null);
        try {
            while (!freeSegments.isEmpty() && this.currentRegionRemainingBytes > 0L) {
                MemorySegment segment = freeSegments.poll();
                int numBytes = (int)Math.min((long)segment.size(), this.currentRegionRemainingBytes);
                ByteBuffer byteBuffer = segment.wrap(0, numBytes);
                try {
                    BufferReaderWriterUtil.readByteBufferFully(this.dataFileChannel, byteBuffer);
                    byteBuffer.flip();
                    this.currentRegionRemainingBytes -= (long)byteBuffer.remaining();
                    this.nextOffsetToRead += (long)byteBuffer.remaining();
                }
                catch (Throwable throwable) {
                    freeSegments.add(segment);
                    throw throwable;
                }
                NetworkBuffer buffer = new NetworkBuffer(segment, recycler);
                buffer.setSize(byteBuffer.remaining());
                try {
                    partialBuffer = this.processBuffer(byteBuffer, buffer, partialBuffer, consumer);
                }
                catch (Throwable throwable) {
                    partialBuffer = new BufferAndHeader(null, null);
                    throw throwable;
                }
                finally {
                    buffer.recycleBuffer();
                }
            }
        }
        finally {
            if (this.headerBuf.position() > 0) {
                this.nextOffsetToRead -= (long)this.headerBuf.position();
                this.currentRegionRemainingBytes += (long)this.headerBuf.position();
                this.headerBuf.clear();
            }
            if (partialBuffer.header != null) {
                this.nextOffsetToRead -= 8L;
                this.currentRegionRemainingBytes += 8L;
            }
            if (partialBuffer.buffer != null) {
                this.nextOffsetToRead -= (long)partialBuffer.buffer.readableBytes();
                this.currentRegionRemainingBytes += (long)partialBuffer.buffer.readableBytes();
                partialBuffer.buffer.recycleBuffer();
            }
        }
        return this.hasRemaining();
    }

    boolean hasRemaining() throws IOException {
        this.moveToNextReadablePosition(this.indexEntryBuf);
        return this.currentRegionRemainingBytes > 0L;
    }

    void initRegionIndex(ByteBuffer initIndexEntryBuffer) throws IOException {
        this.moveToNextReadablePosition(initIndexEntryBuffer);
    }

    long getPriority() {
        return this.nextOffsetToRead;
    }

    private BufferAndHeader processBuffer(ByteBuffer byteBuffer, Buffer buffer, BufferAndHeader partialBuffer, BiConsumer<Buffer, Integer> consumer) {
        BufferHeader header = partialBuffer.header;
        CompositeBuffer targetBuffer = partialBuffer.buffer;
        while (byteBuffer.hasRemaining() && (header != null || (header = this.parseBufferHeader(byteBuffer)) != null)) {
            if (targetBuffer != null) {
                buffer.retainBuffer();
                int position = byteBuffer.position() + targetBuffer.missingLength();
                targetBuffer.addPartialBuffer(buffer.readOnlySlice(byteBuffer.position(), targetBuffer.missingLength()));
                byteBuffer.position(position);
            } else {
                if (byteBuffer.remaining() < header.getLength()) {
                    if (!byteBuffer.hasRemaining()) break;
                    buffer.retainBuffer();
                    targetBuffer = new CompositeBuffer(header);
                    targetBuffer.addPartialBuffer(buffer.readOnlySlice(byteBuffer.position(), byteBuffer.remaining()));
                    break;
                }
                buffer.retainBuffer();
                targetBuffer = new CompositeBuffer(header);
                targetBuffer.addPartialBuffer(buffer.readOnlySlice(byteBuffer.position(), header.getLength()));
                byteBuffer.position(byteBuffer.position() + header.getLength());
            }
            header = null;
            consumer.accept(targetBuffer, this.currentBufferPositionDescriptor.repeatCount);
            targetBuffer = null;
        }
        return new BufferAndHeader(targetBuffer, header);
    }

    private BufferHeader parseBufferHeader(ByteBuffer buffer) {
        BufferHeader header = null;
        if (this.headerBuf.position() > 0) {
            while (this.headerBuf.hasRemaining()) {
                this.headerBuf.put(buffer.get());
            }
            this.headerBuf.flip();
            header = BufferReaderWriterUtil.parseBufferHeader(this.headerBuf);
            this.headerBuf.clear();
        }
        if (header == null && buffer.remaining() < 8) {
            this.headerBuf.put(buffer);
        } else if (header == null) {
            header = BufferReaderWriterUtil.parseBufferHeader(buffer);
        }
        return header;
    }

    @VisibleForTesting
    static class BufferPositionDescriptor {
        private final long offset;
        private final long size;
        private final int repeatCount;

        BufferPositionDescriptor(long offset, long size, int repeatCount) {
            this.offset = offset;
            this.size = size;
            this.repeatCount = repeatCount;
        }

        @VisibleForTesting
        long getOffset() {
            return this.offset;
        }

        @VisibleForTesting
        long getSize() {
            return this.size;
        }

        @VisibleForTesting
        int getRepeatCount() {
            return this.repeatCount;
        }
    }

    private static class BufferAndHeader {
        private final CompositeBuffer buffer;
        private final BufferHeader header;

        BufferAndHeader(CompositeBuffer buffer, BufferHeader header) {
            this.buffer = buffer;
            this.header = header;
        }
    }
}

