/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import org.apache.flink.runtime.executiongraph.IndexRange;
import org.apache.flink.util.Preconditions;

public class ExecutionVertexInputInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int subtaskIndex;
    private final Map<IndexRange, IndexRange> consumedSubpartitionGroups;

    public ExecutionVertexInputInfo(int subtaskIndex, IndexRange partitionIndexRange, IndexRange subpartitionIndexRange) {
        this(subtaskIndex, Collections.singletonMap((IndexRange)Preconditions.checkNotNull((Object)partitionIndexRange), (IndexRange)Preconditions.checkNotNull((Object)subpartitionIndexRange)));
    }

    public ExecutionVertexInputInfo(int subtaskIndex, Map<IndexRange, IndexRange> consumedSubpartitionGroups) {
        this.subtaskIndex = subtaskIndex;
        this.consumedSubpartitionGroups = (Map)Preconditions.checkNotNull(consumedSubpartitionGroups);
    }

    public Map<IndexRange, IndexRange> getConsumedSubpartitionGroups() {
        return this.consumedSubpartitionGroups;
    }

    public int getSubtaskIndex() {
        return this.subtaskIndex;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            ExecutionVertexInputInfo that = (ExecutionVertexInputInfo)obj;
            return that.subtaskIndex == this.subtaskIndex && that.consumedSubpartitionGroups.equals(this.consumedSubpartitionGroups);
        }
        return false;
    }
}

