/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.asyncprocessing.operators;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.state.KeyedStateStore;
import org.apache.flink.api.common.state.v2.State;
import org.apache.flink.api.common.state.v2.StateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.runtime.asyncprocessing.AsyncExecutionController;
import org.apache.flink.runtime.asyncprocessing.AsyncStateException;
import org.apache.flink.runtime.asyncprocessing.RecordContext;
import org.apache.flink.runtime.asyncprocessing.declare.DeclarationManager;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.state.AsyncKeyedStateBackend;
import org.apache.flink.runtime.state.DefaultKeyedStateStore;
import org.apache.flink.runtime.state.v2.adaptor.AsyncKeyedStateBackendAdaptor;
import org.apache.flink.streaming.api.operators.AbstractStreamOperatorV2;
import org.apache.flink.streaming.api.operators.InternalTimeServiceManager;
import org.apache.flink.streaming.api.operators.InternalTimerService;
import org.apache.flink.streaming.api.operators.InternalTimerServiceAsyncImpl;
import org.apache.flink.streaming.api.operators.StreamOperatorParameters;
import org.apache.flink.streaming.api.operators.Triggerable;
import org.apache.flink.streaming.api.operators.sorted.state.BatchExecutionInternalTimeServiceWithAsyncState;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.operators.asyncprocessing.AsyncStateProcessingOperator;
import org.apache.flink.streaming.runtime.operators.asyncprocessing.ElementOrder;
import org.apache.flink.streaming.runtime.streamrecord.LatencyMarker;
import org.apache.flink.streaming.runtime.streamrecord.RecordAttributes;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.tasks.StreamTask;
import org.apache.flink.streaming.runtime.watermarkstatus.WatermarkStatus;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.ThrowingConsumer;
import org.apache.flink.util.function.ThrowingRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public abstract class AbstractAsyncStateStreamOperatorV2<OUT>
extends AbstractStreamOperatorV2<OUT>
implements AsyncStateProcessingOperator {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractAsyncStateStreamOperatorV2.class);
    private final Environment environment;
    private final StreamTask<?, ?> streamTask;
    private AsyncExecutionController asyncExecutionController;
    private RecordContext currentProcessingContext;
    protected DeclarationManager declarationManager;

    public AbstractAsyncStateStreamOperatorV2(StreamOperatorParameters<OUT> parameters, int numberOfInputs) {
        super(parameters, numberOfInputs);
        this.environment = parameters.getContainingTask().getEnvironment();
        this.streamTask = parameters.getContainingTask();
    }

    @Override
    public final void beforeInitializeStateHandler() {
        KeyedStateStore stateStore = this.stateHandler.getKeyedStateStore().orElse(null);
        if (stateStore instanceof DefaultKeyedStateStore) {
            ((DefaultKeyedStateStore)stateStore).setSupportKeyedStateApiSetV2();
        }
        int inFlightRecordsLimit = this.getExecutionConfig().getAsyncStateTotalBufferSize();
        int asyncBufferSize = this.getExecutionConfig().getAsyncStateActiveBufferSize();
        long asyncBufferTimeout = this.getExecutionConfig().getAsyncStateActiveBufferTimeout();
        int maxParallelism = this.getExecutionConfig().getMaxParallelism();
        this.declarationManager = new DeclarationManager();
        if (this.isAsyncStateProcessingEnabled()) {
            AsyncKeyedStateBackend asyncKeyedStateBackend = this.stateHandler.getAsyncKeyedStateBackend();
            if (asyncKeyedStateBackend != null) {
                this.asyncExecutionController = new AsyncExecutionController(this.environment.getMainMailboxExecutor(), this::handleAsyncStateException, asyncKeyedStateBackend.createStateExecutor(), this.declarationManager, maxParallelism, asyncBufferSize, asyncBufferTimeout, inFlightRecordsLimit, asyncKeyedStateBackend, this.getMetricGroup().addGroup("asyncStateProcessing"));
                asyncKeyedStateBackend.setup(this.asyncExecutionController);
                if (asyncKeyedStateBackend instanceof AsyncKeyedStateBackendAdaptor) {
                    LOG.warn("A normal KeyedStateBackend({}) is used when enabling the async state processing. Parallel asynchronous processing does not work. All state access will be processed synchronously.", this.stateHandler.getKeyedStateBackend());
                }
            } else if (this.stateHandler.getKeyedStateBackend() != null) {
                throw new UnsupportedOperationException("Current State Backend doesn't support async access, AsyncExecutionController could not work");
            }
        }
    }

    private void handleAsyncStateException(String message, Throwable exception) {
        this.environment.failExternally(new AsyncStateException(message, exception));
    }

    @Override
    public boolean isAsyncStateProcessingEnabled() {
        return true;
    }

    @Override
    public ElementOrder getElementOrder() {
        return ElementOrder.RECORD_ORDER;
    }

    @Override
    public final <T> void setAsyncKeyedContextElement(StreamRecord<T> record, KeySelector<T, ?> keySelector) throws Exception {
        this.currentProcessingContext = this.asyncExecutionController.buildContext(record.getValue(), keySelector.getKey(record.getValue()));
        this.currentProcessingContext.retain();
        this.asyncExecutionController.setCurrentContext(this.currentProcessingContext);
        this.newKeySelected(this.currentProcessingContext.getKey());
    }

    public void newKeySelected(Object newKey) {
    }

    @Override
    protected <T> void internalSetKeyContextElement(StreamRecord<T> record, KeySelector<T, ?> selector) throws Exception {
        super.internalSetKeyContextElement(record, selector);
        if (selector != null) {
            this.newKeySelected(this.getCurrentKey());
        }
    }

    @Override
    public Object getCurrentKey() {
        if (this.isAsyncStateProcessingEnabled()) {
            RecordContext currentContext = this.asyncExecutionController.getCurrentContext();
            if (currentContext == null) {
                throw new UnsupportedOperationException("Have not set the current key yet, this may because the operator has not started to run, or you are invoking this under a non-keyed context.");
            }
            return currentContext.getKey();
        }
        return super.getCurrentKey();
    }

    @Override
    public final void postProcessElement() {
        this.currentProcessingContext.release();
    }

    @Override
    public final void preserveRecordOrderAndProcess(ThrowingRunnable<Exception> processing) {
        this.asyncExecutionController.syncPointRequestWithCallback(processing, false);
    }

    @Override
    public <K> void asyncProcessWithKey(K key, ThrowingRunnable<Exception> processing) {
        RecordContext oldContext = this.asyncExecutionController.getCurrentContext();
        RecordContext<K> newContext = this.asyncExecutionController.buildContext(null, key, true);
        newContext.retain();
        this.asyncExecutionController.setCurrentContext(newContext);
        this.asyncExecutionController.syncPointRequestWithCallback(processing, true);
        newContext.release();
        this.asyncExecutionController.setCurrentContext(oldContext);
    }

    @Override
    public final DeclarationManager getDeclarationManager() {
        return this.declarationManager;
    }

    @Override
    public final <T> ThrowingConsumer<StreamRecord<T>, Exception> getRecordProcessor(int inputId) {
        throw new UnsupportedOperationException("Never getRecordProcessor from AbstractAsyncStateStreamOperatorV2, since this part is handled by the Input.");
    }

    protected <N, S extends State, T> S getOrCreateKeyedState(@Nonnull N defaultNamespace, @Nonnull TypeSerializer<N> namespaceSerializer, @Nonnull StateDescriptor<T> stateDescriptor) throws Exception {
        return this.stateHandler.getOrCreateKeyedState(defaultNamespace, namespaceSerializer, stateDescriptor);
    }

    @Override
    public void prepareSnapshotPreBarrier(long checkpointId) throws Exception {
        if (this.isAsyncStateProcessingEnabled()) {
            this.asyncExecutionController.drainInflightRecords(0);
        }
    }

    @Override
    public <K, N> InternalTimerService<N> getInternalTimerService(String name, TypeSerializer<N> namespaceSerializer, Triggerable<K, N> triggerable) {
        if (this.timeServiceManager == null) {
            throw new RuntimeException("The timer service has not been initialized.");
        }
        if (!this.isAsyncStateProcessingEnabled()) {
            return super.getInternalTimerService(name, namespaceSerializer, triggerable);
        }
        InternalTimeServiceManager keyedTimeServiceHandler = this.timeServiceManager;
        TypeSerializer keySerializer = this.stateHandler.getKeySerializer();
        Preconditions.checkState((keySerializer != null ? 1 : 0) != 0, (Object)"Timers can only be used on keyed operators.");
        InternalTimerService<N> service = keyedTimeServiceHandler.getInternalTimerService(name, keySerializer, namespaceSerializer, triggerable);
        if (service instanceof InternalTimerServiceAsyncImpl) {
            ((InternalTimerServiceAsyncImpl)service).setup(this.asyncExecutionController);
        } else if (service instanceof BatchExecutionInternalTimeServiceWithAsyncState) {
            ((BatchExecutionInternalTimeServiceWithAsyncState)service).setup(this.asyncExecutionController);
        }
        return service;
    }

    @Override
    protected void reportOrForwardLatencyMarker(LatencyMarker marker) {
        if (!this.isAsyncStateProcessingEnabled()) {
            super.reportOrForwardLatencyMarker(marker);
            return;
        }
        this.asyncExecutionController.processNonRecord(null, (ThrowingRunnable<Exception>)((ThrowingRunnable)() -> super.reportOrForwardLatencyMarker(marker)));
    }

    public Watermark preProcessWatermark(Watermark watermark) throws Exception {
        return watermark;
    }

    public void postProcessWatermark(Watermark watermark) throws Exception {
    }

    @Override
    public final void processWatermark(Watermark mark) throws Exception {
        if (!this.isAsyncStateProcessingEnabled()) {
            Watermark watermark = this.preProcessWatermark(mark);
            if (watermark != null) {
                super.processWatermark(watermark);
                this.postProcessWatermark(watermark);
            }
            return;
        }
        AtomicReference<Object> watermarkRef = new AtomicReference<Object>(null);
        this.asyncExecutionController.processNonRecord((ThrowingRunnable<Exception>)((ThrowingRunnable)() -> {
            watermarkRef.set(this.preProcessWatermark(mark));
            if (this.timeServiceManager != null && watermarkRef.get() != null) {
                this.timeServiceManager.advanceWatermark((Watermark)watermarkRef.get());
            }
        }), (ThrowingRunnable<Exception>)((ThrowingRunnable)() -> {
            if (watermarkRef.get() != null) {
                this.output.emitWatermark((Watermark)watermarkRef.get());
                this.postProcessWatermark((Watermark)watermarkRef.get());
            }
        }));
    }

    @Override
    public void processWatermarkStatus(WatermarkStatus watermarkStatus, int inputId) throws Exception {
        if (!this.isAsyncStateProcessingEnabled()) {
            super.processWatermarkStatus(watermarkStatus, inputId);
            return;
        }
        AtomicBoolean wasIdle = new AtomicBoolean(false);
        AtomicReference<Object> watermarkRef = new AtomicReference<Object>(null);
        this.asyncExecutionController.processNonRecord((ThrowingRunnable<Exception>)((ThrowingRunnable)() -> {
            wasIdle.set(this.combinedWatermark.isIdle());
            if (this.combinedWatermark.updateStatus(inputId - 1, watermarkStatus.isIdle())) {
                watermarkRef.set(this.preProcessWatermark(new Watermark(this.combinedWatermark.getCombinedWatermark())));
                if (this.timeServiceManager != null && watermarkRef.get() != null) {
                    this.timeServiceManager.advanceWatermark((Watermark)watermarkRef.get());
                }
            }
        }), (ThrowingRunnable<Exception>)((ThrowingRunnable)() -> {
            if (watermarkRef.get() != null) {
                this.output.emitWatermark((Watermark)watermarkRef.get());
            }
            if (wasIdle.get() != this.combinedWatermark.isIdle()) {
                this.output.emitWatermarkStatus(watermarkStatus);
            }
        }));
    }

    @Override
    public void processRecordAttributes(RecordAttributes recordAttributes, int inputId) throws Exception {
        if (!this.isAsyncStateProcessingEnabled()) {
            super.processRecordAttributes(recordAttributes, inputId);
            return;
        }
        this.asyncExecutionController.processNonRecord(null, (ThrowingRunnable<Exception>)((ThrowingRunnable)() -> super.processRecordAttributes(recordAttributes, inputId)));
    }

    @VisibleForTesting
    public AsyncExecutionController<?> getAsyncExecutionController() {
        return this.asyncExecutionController;
    }

    @VisibleForTesting
    public RecordContext getCurrentProcessingContext() {
        return this.currentProcessingContext;
    }

    @Override
    public void finish() throws Exception {
        super.finish();
        this.closeIfNeeded();
    }

    @Override
    public void close() throws Exception {
        super.close();
        this.closeIfNeeded();
    }

    private void closeIfNeeded() {
        if (this.isAsyncStateProcessingEnabled() && !this.streamTask.isFailing() && !this.streamTask.isCanceled()) {
            this.asyncExecutionController.drainInflightRecords(0);
        }
    }
}

