/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.datastream;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.flink.FlinkVersion;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerConditions;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerUpgradeTestBase;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.streaming.api.datastream.CoGroupedStreams;
import org.apache.flink.util.TaggedUnion;
import org.assertj.core.api.Condition;

class UnionSerializerUpgradeTest
extends TypeSerializerUpgradeTestBase<TaggedUnion<String, Long>, TaggedUnion<String, Long>> {
    UnionSerializerUpgradeTest() {
    }

    public Collection<TypeSerializerUpgradeTestBase.TestSpecification<?, ?>> createTestSpecifications(FlinkVersion flinkVersion) throws Exception {
        ArrayList testSpecifications = new ArrayList();
        testSpecifications.add(new TypeSerializerUpgradeTestBase.TestSpecification("union-serializer-one", flinkVersion, UnionSerializerOneSetup.class, UnionSerializerOneVerifier.class));
        testSpecifications.add(new TypeSerializerUpgradeTestBase.TestSpecification("union-serializer-two", flinkVersion, UnionSerializerTwoSetup.class, UnionSerializerTwoVerifier.class));
        return testSpecifications;
    }

    private static TypeSerializer<TaggedUnion<String, Long>> stringLongRowSupplier() {
        return new CoGroupedStreams.UnionSerializer((TypeSerializer)StringSerializer.INSTANCE, (TypeSerializer)LongSerializer.INSTANCE);
    }

    public static final class UnionSerializerTwoVerifier
    implements TypeSerializerUpgradeTestBase.UpgradeVerifier<TaggedUnion<String, Long>> {
        public TypeSerializer<TaggedUnion<String, Long>> createUpgradedSerializer() {
            return new CoGroupedStreams.UnionSerializer((TypeSerializer)StringSerializer.INSTANCE, (TypeSerializer)LongSerializer.INSTANCE);
        }

        public Condition<TaggedUnion<String, Long>> testDataCondition() {
            return new Condition(value -> TaggedUnion.two((Object)23456L).equals(value), "", new Object[0]);
        }

        public Condition<TypeSerializerSchemaCompatibility<TaggedUnion<String, Long>>> schemaCompatibilityCondition(FlinkVersion version) {
            return TypeSerializerConditions.isCompatibleAsIs();
        }
    }

    public static final class UnionSerializerTwoSetup
    implements TypeSerializerUpgradeTestBase.PreUpgradeSetup<TaggedUnion<String, Long>> {
        public TypeSerializer<TaggedUnion<String, Long>> createPriorSerializer() {
            return new CoGroupedStreams.UnionSerializer((TypeSerializer)StringSerializer.INSTANCE, (TypeSerializer)LongSerializer.INSTANCE);
        }

        public TaggedUnion<String, Long> createTestData() {
            return TaggedUnion.two((Object)23456L);
        }
    }

    public static final class UnionSerializerOneVerifier
    implements TypeSerializerUpgradeTestBase.UpgradeVerifier<TaggedUnion<String, Long>> {
        public TypeSerializer<TaggedUnion<String, Long>> createUpgradedSerializer() {
            return new CoGroupedStreams.UnionSerializer((TypeSerializer)StringSerializer.INSTANCE, (TypeSerializer)LongSerializer.INSTANCE);
        }

        public Condition<TaggedUnion<String, Long>> testDataCondition() {
            return new Condition(value -> TaggedUnion.one((Object)"flink").equals(value), "", new Object[0]);
        }

        public Condition<TypeSerializerSchemaCompatibility<TaggedUnion<String, Long>>> schemaCompatibilityCondition(FlinkVersion version) {
            return TypeSerializerConditions.isCompatibleAsIs();
        }
    }

    public static final class UnionSerializerOneSetup
    implements TypeSerializerUpgradeTestBase.PreUpgradeSetup<TaggedUnion<String, Long>> {
        public TypeSerializer<TaggedUnion<String, Long>> createPriorSerializer() {
            return new CoGroupedStreams.UnionSerializer((TypeSerializer)StringSerializer.INSTANCE, (TypeSerializer)LongSerializer.INSTANCE);
        }

        public TaggedUnion<String, Long> createTestData() {
            return TaggedUnion.one((Object)"flink");
        }
    }
}

