/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.zookeeper;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.curator.test.TestingServer;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.HighAvailabilityOptions;
import org.apache.flink.core.testutils.CustomExtension;
import org.apache.flink.runtime.highavailability.zookeeper.CuratorFrameworkWithUnhandledErrorListener;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.testutils.ZooKeeperTestUtils;
import org.apache.flink.runtime.util.ZooKeeperUtils;
import org.apache.flink.shaded.curator5.org.apache.curator.framework.CuratorFramework;
import org.apache.flink.util.Preconditions;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperExtension
implements CustomExtension {
    private static final Logger LOG = LoggerFactory.getLogger(ZooKeeperExtension.class);
    @Nullable
    private TestingServer zooKeeperServer;
    @Nullable
    private CuratorFrameworkWithUnhandledErrorListener curatorFrameworkWrapper;

    public void before(ExtensionContext context) throws Exception {
        this.close();
        this.zooKeeperServer = ZooKeeperTestUtils.createAndStartZookeeperTestingServer();
    }

    public void after(ExtensionContext context) throws Exception {
        try {
            this.close();
        }
        catch (IOException e) {
            LOG.warn("Could not properly terminate the {}.", (Object)this.getClass().getSimpleName(), (Object)e);
        }
    }

    public void close() throws IOException {
        this.terminateCuratorFrameworkWrapper();
        this.terminateZooKeeperServer();
    }

    private void terminateCuratorFrameworkWrapper() {
        if (this.curatorFrameworkWrapper != null) {
            this.curatorFrameworkWrapper.close();
            this.curatorFrameworkWrapper = null;
        }
    }

    private void terminateZooKeeperServer() throws IOException {
        if (this.zooKeeperServer != null) {
            this.zooKeeperServer.close();
            this.zooKeeperServer = null;
        }
    }

    public String getConnectString() {
        return this.getRunningZookeeperInstanceOrFail().getConnectString();
    }

    private TestingServer getRunningZookeeperInstanceOrFail() {
        Preconditions.checkState((this.zooKeeperServer != null ? 1 : 0) != 0);
        return this.zooKeeperServer;
    }

    public CuratorFramework getZooKeeperClient(FatalErrorHandler fatalErrorHandler) {
        if (this.curatorFrameworkWrapper == null) {
            this.curatorFrameworkWrapper = this.createCuratorFramework(fatalErrorHandler);
        }
        return this.curatorFrameworkWrapper.asCuratorFramework();
    }

    private CuratorFrameworkWithUnhandledErrorListener createCuratorFramework(FatalErrorHandler fatalErrorHandler) {
        Configuration config = new Configuration();
        config.set(HighAvailabilityOptions.HA_ZOOKEEPER_QUORUM, (Object)this.getConnectString());
        return ZooKeeperUtils.startCuratorFramework((Configuration)config, (FatalErrorHandler)fatalErrorHandler);
    }

    public void restart() throws Exception {
        this.getRunningZookeeperInstanceOrFail().restart();
    }

    public void stop() throws IOException {
        this.getRunningZookeeperInstanceOrFail().stop();
    }
}

