/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util.jartestprogram;

import java.io.Serializable;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.util.jartestprogram.StaticData;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.util.Collector;

public class WordCountWithAnonymousClass {
    public static void main(String[] args) throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource<String> text = StaticData.getDefaultTextLineDataSet(env);
        SingleOutputStreamOperator counts = text.flatMap((FlatMapFunction)new FlatMapFunction<String, Tuple2<String, Integer>>(){

            public void flatMap(String value, Collector<Tuple2<String, Integer>> out) throws Exception {
                String[] tokens;
                for (String token : tokens = value.toLowerCase().split("\\W+")) {
                    if (token.length() <= 0) continue;
                    out.collect((Object)new Tuple2((Object)token, (Object)1));
                }
            }
        }).keyBy((KeySelector & Serializable)value -> (String)value.f0).sum(1);
        counts.print();
        env.execute("WordCount Example");
    }
}

