/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.Random;
import java.util.stream.Collectors;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.util.DualKeyLinkedMap;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class DualKeyLinkedMapTest {
    DualKeyLinkedMapTest() {
    }

    @Test
    void testKeySets() {
        Random random = new Random();
        HashSet<Tuple2> keys = new HashSet<Tuple2>();
        for (int i = 0; i < 10; ++i) {
            int keyA = random.nextInt();
            int keyB = random.nextInt();
            keys.add(Tuple2.of((Object)keyA, (Object)keyB));
        }
        DualKeyLinkedMap dualKeyMap = new DualKeyLinkedMap();
        for (Tuple2 key : keys) {
            dualKeyMap.put((Object)((Integer)key.f0), (Object)((Integer)key.f1), (Object)"foobar");
        }
        Assertions.assertThat((Collection)dualKeyMap.keySetA()).isEqualTo(keys.stream().map(t -> (Integer)t.f0).collect(Collectors.toSet()));
        Assertions.assertThat((Collection)dualKeyMap.keySetB()).isEqualTo(keys.stream().map(t -> (Integer)t.f1).collect(Collectors.toSet()));
    }

    @Test
    void ensuresOneToOneMappingBetweenKeysSamePrimaryKey() {
        DualKeyLinkedMap map = new DualKeyLinkedMap();
        String secondValue = "barfoo";
        map.put((Object)1, (Object)1, (Object)"foobar");
        map.put((Object)1, (Object)2, (Object)"barfoo");
        Assertions.assertThat((String)((String)map.getValueByKeyB((Object)1))).isNull();
        Assertions.assertThat((String)((String)map.getValueByKeyA((Object)1))).isEqualTo("barfoo");
        Assertions.assertThat((String)((String)map.getValueByKeyB((Object)2))).isEqualTo("barfoo");
    }

    @Test
    void ensuresOneToOneMappingBetweenKeysSameSecondaryKey() {
        DualKeyLinkedMap map = new DualKeyLinkedMap();
        String secondValue = "barfoo";
        map.put((Object)1, (Object)1, (Object)"foobar");
        map.put((Object)2, (Object)1, (Object)"barfoo");
        Assertions.assertThat((String)((String)map.getValueByKeyA((Object)1))).isNull();
        Assertions.assertThat((String)((String)map.getValueByKeyB((Object)1))).isEqualTo("barfoo");
        Assertions.assertThat((String)((String)map.getValueByKeyA((Object)2))).isEqualTo("barfoo");
    }

    @Test
    void testPrimaryKeyOrderIsNotAffectedIfReInsertedWithSameSecondaryKey() {
        DualKeyLinkedMap map = new DualKeyLinkedMap();
        String value1 = "1";
        map.put((Object)1, (Object)1, (Object)"1");
        String value2 = "2";
        map.put((Object)2, (Object)2, (Object)"2");
        String value3 = "3";
        map.put((Object)1, (Object)1, (Object)"3");
        Assertions.assertThat((Integer)((Integer)map.keySetA().iterator().next())).isOne();
        Assertions.assertThat((String)((String)map.values().iterator().next())).isEqualTo("3");
    }

    @Test
    void testPrimaryKeyOrderIsNotAffectedIfReInsertedWithDifferentSecondaryKey() {
        DualKeyLinkedMap map = new DualKeyLinkedMap();
        String value1 = "1";
        map.put((Object)1, (Object)1, (Object)"1");
        String value2 = "2";
        map.put((Object)2, (Object)2, (Object)"2");
        String value3 = "3";
        map.put((Object)1, (Object)3, (Object)"3");
        Assertions.assertThat((Integer)((Integer)map.keySetA().iterator().next())).isOne();
        Assertions.assertThat((String)((String)map.values().iterator().next())).isEqualTo("3");
    }
}

