/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.testutils;

import java.util.Objects;
import org.apache.flink.runtime.state.StateEntry;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

public class StateEntryMatcher<K, N, S>
extends TypeSafeMatcher<StateEntry<K, N, S>> {
    private final K key;
    private final N namespace;
    private final S state;

    StateEntryMatcher(K key, N namespace, S state) {
        this.key = key;
        this.namespace = namespace;
        this.state = state;
    }

    public static <K, N, S> StateEntryMatcher<K, N, S> entry(K key, N namespace, S state) {
        return new StateEntryMatcher<K, N, S>(key, namespace, state);
    }

    protected boolean matchesSafely(StateEntry<K, N, S> item) {
        return Objects.equals(item.getKey(), this.key) && Objects.equals(item.getNamespace(), this.namespace) && Objects.equals(item.getState(), this.state);
    }

    public void describeTo(Description description) {
        description.appendText(String.format("expected entry: key: %s, namespace: %s, state: %s", this.key, this.namespace, this.state));
    }
}

