/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adaptivebatch;

import org.apache.flink.runtime.scheduler.adaptivebatch.BisectionSearchUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class BisectionSearchUtilsTest {
    BisectionSearchUtilsTest() {
    }

    @Test
    void testFindMinLegalValue() {
        Assertions.assertThat((long)BisectionSearchUtils.findMinLegalValue(value -> 29L / value <= 3L, (long)1L, (long)17L)).isEqualTo(8L);
        Assertions.assertThat((long)BisectionSearchUtils.findMinLegalValue(value -> 29L / value <= 3L, (long)8L, (long)17L)).isEqualTo(8L);
        Assertions.assertThat((long)BisectionSearchUtils.findMinLegalValue(value -> 29L / value <= 3L, (long)1L, (long)8L)).isEqualTo(8L);
        Assertions.assertThat((long)BisectionSearchUtils.findMinLegalValue(value -> 29L / value <= 3L, (long)9L, (long)17L)).isEqualTo(9L);
        Assertions.assertThat((long)BisectionSearchUtils.findMinLegalValue(value -> 29L / value <= 3L, (long)1L, (long)7L)).isEqualTo(-1L);
    }

    @Test
    void testFindMaxLegalValue() {
        Assertions.assertThat((long)BisectionSearchUtils.findMaxLegalValue(value -> value / 3L <= 3L, (long)1L, (long)17L)).isEqualTo(11L);
        Assertions.assertThat((long)BisectionSearchUtils.findMaxLegalValue(value -> value / 3L <= 3L, (long)11L, (long)17L)).isEqualTo(11L);
        Assertions.assertThat((long)BisectionSearchUtils.findMaxLegalValue(value -> value / 3L <= 3L, (long)1L, (long)11L)).isEqualTo(11L);
        Assertions.assertThat((long)BisectionSearchUtils.findMaxLegalValue(value -> value / 3L <= 3L, (long)1L, (long)10L)).isEqualTo(10L);
        Assertions.assertThat((long)BisectionSearchUtils.findMaxLegalValue(value -> value / 3L <= 3L, (long)12L, (long)17L)).isEqualTo(-1L);
    }
}

