/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adaptive;

import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ScheduledFuture;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.apache.flink.core.testutils.CompletedScheduledFuture;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.scheduler.ExecutionGraphHandler;
import org.apache.flink.runtime.scheduler.OperatorCoordinatorHandler;
import org.apache.flink.runtime.scheduler.adaptive.ExecutingTest;
import org.apache.flink.runtime.scheduler.adaptive.MockStateWithExecutionGraphContext;
import org.apache.flink.runtime.scheduler.adaptive.Restarting;
import org.apache.flink.runtime.scheduler.adaptive.State;
import org.apache.flink.runtime.scheduler.adaptive.StateValidator;
import org.apache.flink.runtime.scheduler.adaptive.WaitingForResourcesTest;
import org.apache.flink.runtime.scheduler.adaptive.allocator.VertexParallelism;
import org.apache.flink.runtime.scheduler.exceptionhistory.ExceptionHistoryEntry;
import org.apache.flink.runtime.scheduler.exceptionhistory.RootExceptionHistoryEntry;

class MockRestartingContext
extends MockStateWithExecutionGraphContext
implements Restarting.Context {
    private final StateValidator<ExecutingTest.CancellingArguments> cancellingStateValidator = new StateValidator("Cancelling");
    private final StateValidator<ExecutionGraph> waitingForResourcesStateValidator = new StateValidator("WaitingForResources");
    private final StateValidator<ExecutionGraph> creatingExecutionGraphStateValidator = new StateValidator("CreatingExecutionGraph");
    @Nullable
    private VertexParallelism availableVertexParallelism;

    MockRestartingContext() {
    }

    public void setExpectCancelling(Consumer<ExecutingTest.CancellingArguments> asserter) {
        this.cancellingStateValidator.expectInput(asserter);
    }

    public void setExpectWaitingForResources() {
        this.waitingForResourcesStateValidator.expectInput(WaitingForResourcesTest.assertNonNull());
    }

    public void setExpectCreatingExecutionGraph() {
        this.creatingExecutionGraphStateValidator.expectInput(WaitingForResourcesTest.assertNonNull());
    }

    public void setAvailableVertexParallelism(@Nullable VertexParallelism availableVertexParallelism) {
        this.availableVertexParallelism = availableVertexParallelism;
    }

    public void goToCanceling(ExecutionGraph executionGraph, ExecutionGraphHandler executionGraphHandler, OperatorCoordinatorHandler operatorCoordinatorHandler, List<ExceptionHistoryEntry> failureCollection) {
        this.cancellingStateValidator.validateInput(new ExecutingTest.CancellingArguments(executionGraph, executionGraphHandler, operatorCoordinatorHandler));
        this.hadStateTransition = true;
    }

    @Override
    public void archiveFailure(RootExceptionHistoryEntry failure) {
    }

    public void goToWaitingForResources(@Nullable ExecutionGraph previousExecutionGraph) {
        this.waitingForResourcesStateValidator.validateInput(previousExecutionGraph);
        this.hadStateTransition = true;
    }

    public void goToCreatingExecutionGraph(@Nullable ExecutionGraph previousExecutionGraph) {
        this.creatingExecutionGraphStateValidator.validateInput(previousExecutionGraph);
        this.hadStateTransition = true;
    }

    public ScheduledFuture<?> runIfState(State expectedState, Runnable action, Duration delay) {
        if (!this.hadStateTransition) {
            action.run();
        }
        return CompletedScheduledFuture.create(null);
    }

    public Optional<VertexParallelism> getAvailableVertexParallelism() {
        return Optional.ofNullable(this.availableVertexParallelism);
    }

    @Override
    public void close() throws Exception {
        super.close();
        this.cancellingStateValidator.close();
        this.waitingForResourcesStateValidator.close();
        this.creatingExecutionGraphStateValidator.close();
    }
}

