/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler;

import javax.annotation.Nullable;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.executiongraph.utils.SimpleAckingTaskManagerGateway;
import org.apache.flink.runtime.jobmanager.slots.TaskManagerGateway;
import org.apache.flink.runtime.jobmaster.slotpool.PhysicalSlot;
import org.apache.flink.runtime.taskmanager.LocalTaskManagerLocation;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.util.Preconditions;

public class TestingPhysicalSlot
implements PhysicalSlot {
    private final AllocationID allocationId;
    private final TaskManagerLocation taskManagerLocation;
    private final int physicalSlotNumber;
    private final TaskManagerGateway taskManagerGateway;
    private final ResourceProfile resourceProfile;
    @Nullable
    private PhysicalSlot.Payload payload;

    TestingPhysicalSlot(ResourceProfile resourceProfile, AllocationID allocationId) {
        this(allocationId, new LocalTaskManagerLocation(), 0, new SimpleAckingTaskManagerGateway(), resourceProfile);
    }

    TestingPhysicalSlot(AllocationID allocationId, TaskManagerLocation taskManagerLocation, int physicalSlotNumber, TaskManagerGateway taskManagerGateway, ResourceProfile resourceProfile) {
        this.allocationId = (AllocationID)Preconditions.checkNotNull((Object)allocationId);
        this.taskManagerLocation = (TaskManagerLocation)Preconditions.checkNotNull((Object)taskManagerLocation);
        this.physicalSlotNumber = physicalSlotNumber;
        this.taskManagerGateway = (TaskManagerGateway)Preconditions.checkNotNull((Object)taskManagerGateway);
        this.resourceProfile = resourceProfile;
    }

    public AllocationID getAllocationId() {
        return this.allocationId;
    }

    public TaskManagerLocation getTaskManagerLocation() {
        return this.taskManagerLocation;
    }

    public int getPhysicalSlotNumber() {
        return this.physicalSlotNumber;
    }

    public TaskManagerGateway getTaskManagerGateway() {
        return this.taskManagerGateway;
    }

    public ResourceProfile getResourceProfile() {
        return this.resourceProfile;
    }

    public boolean willBeOccupiedIndefinitely() {
        return true;
    }

    public boolean tryAssignPayload(PhysicalSlot.Payload payload) {
        if (this.payload != null) {
            return false;
        }
        this.payload = payload;
        return true;
    }

    @Nullable
    public PhysicalSlot.Payload getPayload() {
        return this.payload;
    }

    public void releasePayload(Throwable cause) {
        if (this.payload != null) {
            this.payload.release(cause);
            this.payload = null;
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private AllocationID allocationID = new AllocationID();
        private TaskManagerLocation taskManagerLocation = new LocalTaskManagerLocation();
        private int physicalSlotNumber = 0;
        private TaskManagerGateway taskManagerGateway = new SimpleAckingTaskManagerGateway();
        private ResourceProfile resourceProfile = ResourceProfile.ANY;

        private Builder() {
        }

        public Builder withAllocationID(AllocationID allocationID) {
            this.allocationID = allocationID;
            return this;
        }

        public Builder withTaskManagerLocation(TaskManagerLocation taskManagerLocation) {
            this.taskManagerLocation = taskManagerLocation;
            return this;
        }

        public Builder withPhysicalSlotNumber(int physicalSlotNumber) {
            this.physicalSlotNumber = physicalSlotNumber;
            return this;
        }

        public Builder withTaskManagerGateway(TaskManagerGateway taskManagerGateway) {
            this.taskManagerGateway = taskManagerGateway;
            return this;
        }

        public Builder withResourceProfile(ResourceProfile resourceProfile) {
            this.resourceProfile = resourceProfile;
            return this;
        }

        public TestingPhysicalSlot build() {
            return new TestingPhysicalSlot(this.allocationID, this.taskManagerLocation, this.physicalSlotNumber, this.taskManagerGateway, this.resourceProfile);
        }
    }
}

