/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Random;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.rest.messages.JobVertexDetailsInfo;
import org.apache.flink.runtime.rest.messages.RestResponseMarshallingTestBase;
import org.apache.flink.runtime.rest.messages.job.SubtaskExecutionAttemptDetailsInfo;
import org.apache.flink.runtime.rest.messages.job.metrics.IOMetricsInfo;
import org.apache.flink.testutils.junit.extensions.parameterized.NoOpTestExtension;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={NoOpTestExtension.class})
class JobVertexDetailsInfoTest
extends RestResponseMarshallingTestBase<JobVertexDetailsInfo> {
    JobVertexDetailsInfoTest() {
    }

    @Override
    protected Class<JobVertexDetailsInfo> getTestResponseClass() {
        return JobVertexDetailsInfo.class;
    }

    @Override
    protected JobVertexDetailsInfo getTestResponseInstance() throws Exception {
        Random random = new Random();
        IOMetricsInfo jobVertexMetrics = new IOMetricsInfo(random.nextLong(), random.nextBoolean(), random.nextLong(), random.nextBoolean(), random.nextLong(), random.nextBoolean(), random.nextLong(), random.nextBoolean(), Math.abs(random.nextLong()), Math.abs(random.nextLong()), Math.abs(random.nextDouble()));
        ArrayList<SubtaskExecutionAttemptDetailsInfo> vertexTaskDetailList = new ArrayList<SubtaskExecutionAttemptDetailsInfo>();
        HashMap<ExecutionState, Long> statusDuration = new HashMap<ExecutionState, Long>();
        statusDuration.put(ExecutionState.CREATED, 10L);
        statusDuration.put(ExecutionState.SCHEDULED, 20L);
        statusDuration.put(ExecutionState.DEPLOYING, 30L);
        statusDuration.put(ExecutionState.INITIALIZING, 40L);
        statusDuration.put(ExecutionState.RUNNING, 50L);
        vertexTaskDetailList.add(new SubtaskExecutionAttemptDetailsInfo(0, ExecutionState.CREATED, random.nextInt(), "local1:123", System.currentTimeMillis(), System.currentTimeMillis(), 1L, jobVertexMetrics, "taskmanagerId1", statusDuration, null));
        vertexTaskDetailList.add(new SubtaskExecutionAttemptDetailsInfo(1, ExecutionState.RUNNING, random.nextInt(), "local2:123", System.currentTimeMillis(), System.currentTimeMillis(), 1L, jobVertexMetrics, "taskmanagerId2", statusDuration, Collections.singletonList(new SubtaskExecutionAttemptDetailsInfo(1, ExecutionState.FAILED, random.nextInt(), "local2:123", System.currentTimeMillis(), System.currentTimeMillis(), 1L, jobVertexMetrics, "taskmanagerId2", statusDuration, null))));
        vertexTaskDetailList.add(new SubtaskExecutionAttemptDetailsInfo(2, ExecutionState.FINISHED, random.nextInt(), "local3:123", System.currentTimeMillis(), System.currentTimeMillis(), 1L, jobVertexMetrics, "taskmanagerId3", statusDuration, null));
        int parallelism = 1 + random.nextInt() / 3;
        return new JobVertexDetailsInfo(new JobVertexID(), "jobVertex" + random.nextLong(), parallelism, 2 * parallelism, System.currentTimeMillis(), vertexTaskDetailList);
    }
}

