/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.flink.runtime.rest.RestServerEndpoint;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.slf4j.Logger;
import org.slf4j.helpers.NOPLogger;

class RestServerEndpointTest {
    RestServerEndpointTest() {
    }

    @Test
    void testRestHandlerUrlSorting() {
        int numberHandlers = 5;
        ArrayList<String> handlerUrls = new ArrayList<String>(5);
        handlerUrls.add("/jobs/overview");
        handlerUrls.add("/jobs/:jobid");
        handlerUrls.add("/jobs");
        handlerUrls.add("/:*");
        handlerUrls.add("/jobs/:jobid/config");
        ArrayList<String> expected = new ArrayList<String>(5);
        expected.add("/jobs");
        expected.add("/jobs/overview");
        expected.add("/jobs/:jobid");
        expected.add("/jobs/:jobid/config");
        expected.add("/:*");
        Collections.sort(handlerUrls, new RestServerEndpoint.RestHandlerUrlComparator.CaseInsensitiveOrderComparator());
        Assertions.assertThat(handlerUrls).isEqualTo(expected);
    }

    @Test
    void testCreateUploadDir(@TempDir File file) throws Exception {
        Path testUploadDir = file.toPath().resolve("testUploadDir");
        Assertions.assertThat((boolean)Files.exists(testUploadDir, new LinkOption[0])).isFalse();
        RestServerEndpoint.createUploadDir((Path)testUploadDir, (Logger)NOPLogger.NOP_LOGGER, (boolean)true);
        Assertions.assertThat((boolean)Files.exists(testUploadDir, new LinkOption[0])).isTrue();
    }

    @Tag(value="org.apache.flink.testutils.junit.FailsInGHAContainerWithRootUser")
    @Test
    void testCreateUploadDirFails(@TempDir File file) throws Exception {
        Assertions.assertThat((boolean)file.setWritable(false));
        Path testUploadDir = file.toPath().resolve("testUploadDir");
        Assertions.assertThat((boolean)Files.exists(testUploadDir, new LinkOption[0])).isFalse();
        Assertions.assertThatThrownBy(() -> RestServerEndpoint.createUploadDir((Path)testUploadDir, (Logger)NOPLogger.NOP_LOGGER, (boolean)true)).isInstanceOf(IOException.class);
    }
}

