/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager;

import java.time.Duration;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.RpcOptions;
import org.apache.flink.runtime.blocklist.BlocklistHandler;
import org.apache.flink.runtime.blocklist.BlocklistUtils;
import org.apache.flink.runtime.clusterframework.ApplicationStatus;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.entrypoint.ClusterInformation;
import org.apache.flink.runtime.heartbeat.HeartbeatServices;
import org.apache.flink.runtime.io.network.partition.ResourceManagerPartitionTrackerFactory;
import org.apache.flink.runtime.io.network.partition.ResourceManagerPartitionTrackerImpl;
import org.apache.flink.runtime.metrics.groups.ResourceManagerMetricGroup;
import org.apache.flink.runtime.resourcemanager.JobLeaderIdService;
import org.apache.flink.runtime.resourcemanager.ResourceManager;
import org.apache.flink.runtime.resourcemanager.ResourceManagerFactory;
import org.apache.flink.runtime.resourcemanager.ResourceManagerRuntimeServices;
import org.apache.flink.runtime.resourcemanager.ResourceManagerRuntimeServicesConfiguration;
import org.apache.flink.runtime.resourcemanager.StandaloneResourceManagerFactory;
import org.apache.flink.runtime.resourcemanager.slotmanager.NonSupportedResourceAllocatorImpl;
import org.apache.flink.runtime.resourcemanager.slotmanager.ResourceAllocator;
import org.apache.flink.runtime.resourcemanager.slotmanager.SlotManager;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.security.token.DelegationTokenManager;
import org.apache.flink.util.ConfigurationException;
import org.apache.flink.util.function.TriConsumer;

public class TestingResourceManagerFactory
extends ResourceManagerFactory<ResourceID> {
    private final Consumer<UUID> initializeConsumer;
    private final Consumer<UUID> terminateConsumer;
    private final TriConsumer<UUID, ApplicationStatus, String> internalDeregisterApplicationConsumer;
    private final BiFunction<ResourceManager<?>, CompletableFuture<Void>, CompletableFuture<Void>> getTerminationFutureFunction;
    private final boolean supportMultiLeaderSession;

    public TestingResourceManagerFactory(Consumer<UUID> initializeConsumer, Consumer<UUID> terminateConsumer, TriConsumer<UUID, ApplicationStatus, String> internalDeregisterApplicationConsumer, BiFunction<ResourceManager<?>, CompletableFuture<Void>, CompletableFuture<Void>> getTerminationFutureFunction, boolean supportMultiLeaderSession) {
        this.initializeConsumer = initializeConsumer;
        this.terminateConsumer = terminateConsumer;
        this.internalDeregisterApplicationConsumer = internalDeregisterApplicationConsumer;
        this.getTerminationFutureFunction = getTerminationFutureFunction;
        this.supportMultiLeaderSession = supportMultiLeaderSession;
    }

    protected ResourceManager<ResourceID> createResourceManager(Configuration configuration, ResourceID resourceId, RpcService rpcService, UUID leaderSessionId, HeartbeatServices heartbeatServices, DelegationTokenManager delegationTokenManager, FatalErrorHandler fatalErrorHandler, ClusterInformation clusterInformation, @Nullable String webInterfaceUrl, ResourceManagerMetricGroup resourceManagerMetricGroup, ResourceManagerRuntimeServices resourceManagerRuntimeServices, Executor ioExecutor) {
        return new MockResourceManager(rpcService, leaderSessionId, resourceId, heartbeatServices, delegationTokenManager, resourceManagerRuntimeServices.getSlotManager(), ResourceManagerPartitionTrackerImpl::new, BlocklistUtils.loadBlocklistHandlerFactory((Configuration)configuration), resourceManagerRuntimeServices.getJobLeaderIdService(), clusterInformation, fatalErrorHandler, resourceManagerMetricGroup, (Duration)configuration.get(RpcOptions.ASK_TIMEOUT_DURATION), ioExecutor);
    }

    protected ResourceManagerRuntimeServicesConfiguration createResourceManagerRuntimeServicesConfiguration(Configuration configuration) throws ConfigurationException {
        return StandaloneResourceManagerFactory.getInstance().createResourceManagerRuntimeServicesConfiguration(configuration);
    }

    public boolean supportMultiLeaderSession() {
        return this.supportMultiLeaderSession;
    }

    private class MockResourceManager
    extends ResourceManager<ResourceID> {
        private final UUID leaderSessionId;

        public MockResourceManager(RpcService rpcService, UUID leaderSessionId, ResourceID resourceId, HeartbeatServices heartbeatServices, DelegationTokenManager delegationTokenManager, SlotManager slotManager, ResourceManagerPartitionTrackerFactory clusterPartitionTrackerFactory, BlocklistHandler.Factory blocklistHandlerFactory, JobLeaderIdService jobLeaderIdService, ClusterInformation clusterInformation, FatalErrorHandler fatalErrorHandler, ResourceManagerMetricGroup resourceManagerMetricGroup, Duration rpcTimeout, Executor ioExecutor) {
            super(rpcService, leaderSessionId, resourceId, heartbeatServices, delegationTokenManager, slotManager, clusterPartitionTrackerFactory, blocklistHandlerFactory, jobLeaderIdService, clusterInformation, fatalErrorHandler, resourceManagerMetricGroup, rpcTimeout, ioExecutor);
            this.leaderSessionId = leaderSessionId;
        }

        protected void initialize() {
            TestingResourceManagerFactory.this.initializeConsumer.accept(this.leaderSessionId);
        }

        protected void terminate() {
            TestingResourceManagerFactory.this.terminateConsumer.accept(this.leaderSessionId);
        }

        protected void internalDeregisterApplication(ApplicationStatus finalStatus, @Nullable String optionalDiagnostics) {
            TestingResourceManagerFactory.this.internalDeregisterApplicationConsumer.accept((Object)this.leaderSessionId, (Object)finalStatus, (Object)optionalDiagnostics);
        }

        protected Optional<ResourceID> getWorkerNodeIfAcceptRegistration(ResourceID resourceID) {
            throw new UnsupportedOperationException();
        }

        public CompletableFuture<Void> getTerminationFuture() {
            return TestingResourceManagerFactory.this.getTerminationFutureFunction.apply(this, super.getTerminationFuture());
        }

        public CompletableFuture<Void> getReadyToServeFuture() {
            return CompletableFuture.completedFuture(null);
        }

        protected ResourceAllocator getResourceAllocator() {
            return NonSupportedResourceAllocatorImpl.INSTANCE;
        }
    }

    public static class Builder {
        private Consumer<UUID> initializeConsumer = ignore -> {};
        private Consumer<UUID> terminateConsumer = ignore -> {};
        private TriConsumer<UUID, ApplicationStatus, String> internalDeregisterApplicationConsumer = (ignore1, ignore2, ignore3) -> {};
        private BiFunction<ResourceManager<?>, CompletableFuture<Void>, CompletableFuture<Void>> getTerminationFutureFunction = (rm, superTerminationFuture) -> superTerminationFuture;
        private boolean supportMultiLeaderSession = true;

        public Builder setInitializeConsumer(Consumer<UUID> initializeConsumer) {
            this.initializeConsumer = initializeConsumer;
            return this;
        }

        public Builder setTerminateConsumer(Consumer<UUID> terminateConsumer) {
            this.terminateConsumer = terminateConsumer;
            return this;
        }

        public Builder setInternalDeregisterApplicationConsumer(TriConsumer<UUID, ApplicationStatus, String> internalDeregisterApplicationConsumer) {
            this.internalDeregisterApplicationConsumer = internalDeregisterApplicationConsumer;
            return this;
        }

        public Builder setGetTerminationFutureFunction(BiFunction<ResourceManager<?>, CompletableFuture<Void>, CompletableFuture<Void>> getTerminationFutureFunction) {
            this.getTerminationFutureFunction = getTerminationFutureFunction;
            return this;
        }

        public Builder setSupportMultiLeaderSession(boolean supportMultiLeaderSession) {
            this.supportMultiLeaderSession = supportMultiLeaderSession;
            return this;
        }

        public TestingResourceManagerFactory build() {
            return new TestingResourceManagerFactory(this.initializeConsumer, this.terminateConsumer, this.internalDeregisterApplicationConsumer, this.getTerminationFutureFunction, this.supportMultiLeaderSession);
        }
    }
}

