/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.resettable;

import java.util.ArrayList;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.disk.iomanager.IOManagerAsync;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.runtime.memory.MemoryManagerBuilder;
import org.apache.flink.runtime.operators.resettable.SpillingResettableMutableObjectIterator;
import org.apache.flink.runtime.operators.testutils.DummyInvokable;
import org.apache.flink.runtime.operators.testutils.MutableObjectIteratorWrapper;
import org.apache.flink.runtime.testutils.recordutils.RecordSerializer;
import org.apache.flink.types.IntValue;
import org.apache.flink.types.Record;
import org.apache.flink.types.Value;
import org.apache.flink.util.MutableObjectIterator;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class SpillingResettableMutableObjectIteratorTest {
    private static final int NUM_TESTRECORDS = 50000;
    private static final int MEMORY_CAPACITY = 0xA00000;
    private IOManager ioman;
    private MemoryManager memman;
    private MutableObjectIterator<Record> reader;
    private final TypeSerializer<Record> serializer = RecordSerializer.get();

    SpillingResettableMutableObjectIteratorTest() {
    }

    @BeforeEach
    void startup() {
        this.memman = MemoryManagerBuilder.newBuilder().setMemorySize(0xA00000L).build();
        this.ioman = new IOManagerAsync();
        ArrayList<Record> objects = new ArrayList<Record>(50000);
        for (int i = 0; i < 50000; ++i) {
            Record tmp = new Record((Value)new IntValue(i));
            objects.add(tmp);
        }
        this.reader = new MutableObjectIteratorWrapper(objects.iterator());
    }

    @AfterEach
    void shutdown() throws Exception {
        this.ioman.close();
        this.ioman = null;
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.memman.verifyEmpty()).withFailMessage("A memory leak has occurred: Not all memory was properly returned to the memory manager.", new Object[0])).isTrue();
        this.memman.shutdown();
        this.memman = null;
    }

    @Test
    void testResettableIterator() {
        try {
            DummyInvokable memOwner = new DummyInvokable();
            SpillingResettableMutableObjectIterator iterator = new SpillingResettableMutableObjectIterator(this.reader, this.serializer, this.memman, this.ioman, 2, (AbstractInvokable)memOwner);
            iterator.open();
            int count = 0;
            Record target = new Record();
            while ((target = (Record)iterator.next((Object)target)) != null) {
                ((AbstractIntegerAssert)Assertions.assertThat((int)((IntValue)target.getField(0, IntValue.class)).getValue()).withFailMessage("In initial run, element %d does not match expected value!", new Object[]{count})).isEqualTo(count++);
            }
            ((AbstractIntegerAssert)Assertions.assertThat((int)count).withFailMessage("Too few elements were deserialized in initial run!", new Object[0])).isEqualTo(50000);
            for (int j = 0; j < 10; ++j) {
                count = 0;
                iterator.reset();
                target = new Record();
                while ((target = (Record)iterator.next((Object)target)) != null) {
                    ((AbstractIntegerAssert)Assertions.assertThat((int)((IntValue)target.getField(0, IntValue.class)).getValue()).withFailMessage("After reset nr. %d element %d does not match expected value!", new Object[]{j + 1, count})).isEqualTo(count++);
                }
                ((AbstractIntegerAssert)Assertions.assertThat((int)count).withFailMessage("Too few elements were deserialized after reset nr. %d!", new Object[]{j + 1})).isEqualTo(50000);
            }
            iterator.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assertions.fail((String)"Test encountered an exception.");
        }
    }

    @Test
    void testResettableIteratorInMemory() {
        try {
            DummyInvokable memOwner = new DummyInvokable();
            SpillingResettableMutableObjectIterator iterator = new SpillingResettableMutableObjectIterator(this.reader, this.serializer, this.memman, this.ioman, 20, (AbstractInvokable)memOwner);
            iterator.open();
            int count = 0;
            Record target = new Record();
            while ((target = (Record)iterator.next((Object)target)) != null) {
                ((AbstractIntegerAssert)Assertions.assertThat((int)((IntValue)target.getField(0, IntValue.class)).getValue()).withFailMessage("In initial run, element %d does not match expected value!", new Object[]{count})).isEqualTo(count++);
            }
            ((AbstractIntegerAssert)Assertions.assertThat((int)count).withFailMessage("Too few elements were deserialized in initial run!", new Object[0])).isEqualTo(50000);
            for (int j = 0; j < 10; ++j) {
                count = 0;
                iterator.reset();
                target = new Record();
                while ((target = (Record)iterator.next((Object)target)) != null) {
                    ((AbstractIntegerAssert)Assertions.assertThat((int)((IntValue)target.getField(0, IntValue.class)).getValue()).withFailMessage("After reset nr. %d element %d does not match expected value!", new Object[]{j + 1, count})).isEqualTo(count++);
                }
                ((AbstractIntegerAssert)Assertions.assertThat((int)count).withFailMessage("Too few elements were deserialized after reset nr. %d!", new Object[]{j + 1})).isEqualTo(50000);
            }
            iterator.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assertions.fail((String)"Test encountered an exception.");
        }
    }
}

