/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster;

import java.util.Map;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.ExecutionGraphTestUtils;
import org.apache.flink.runtime.jobmaster.DefaultExecutionDeploymentTracker;
import org.apache.flink.runtime.jobmaster.ExecutionDeploymentState;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class DefaultExecutionDeploymentTrackerTest {
    DefaultExecutionDeploymentTrackerTest() {
    }

    @Test
    void testStartTracking() {
        DefaultExecutionDeploymentTracker tracker = new DefaultExecutionDeploymentTracker();
        ExecutionAttemptID attemptId1 = ExecutionGraphTestUtils.createExecutionAttemptId();
        ResourceID resourceId1 = ResourceID.generate();
        tracker.startTrackingPendingDeploymentOf(attemptId1, resourceId1);
        Assertions.assertThat((Map)tracker.getExecutionsOn(resourceId1)).containsEntry((Object)attemptId1, (Object)ExecutionDeploymentState.PENDING);
        tracker.completeDeploymentOf(attemptId1);
        Assertions.assertThat((Map)tracker.getExecutionsOn(resourceId1)).containsEntry((Object)attemptId1, (Object)ExecutionDeploymentState.DEPLOYED);
    }

    @Test
    void testStopTrackingCompletedDeployment() {
        DefaultExecutionDeploymentTracker tracker = new DefaultExecutionDeploymentTracker();
        ExecutionAttemptID attemptId1 = ExecutionGraphTestUtils.createExecutionAttemptId();
        ResourceID resourceId1 = ResourceID.generate();
        tracker.startTrackingPendingDeploymentOf(attemptId1, resourceId1);
        tracker.completeDeploymentOf(attemptId1);
        tracker.stopTrackingDeploymentOf(attemptId1);
        Assertions.assertThat(tracker.getExecutionsOn(resourceId1).entrySet()).isEmpty();
    }

    @Test
    void testStopTrackingPendingDeployment() {
        DefaultExecutionDeploymentTracker tracker = new DefaultExecutionDeploymentTracker();
        ExecutionAttemptID attemptId1 = ExecutionGraphTestUtils.createExecutionAttemptId();
        ResourceID resourceId1 = ResourceID.generate();
        tracker.startTrackingPendingDeploymentOf(attemptId1, resourceId1);
        tracker.stopTrackingDeploymentOf(attemptId1);
        Assertions.assertThat(tracker.getExecutionsOn(resourceId1).entrySet()).isEmpty();
    }

    @Test
    void testStopTrackingDoesNotAffectOtherIds() {
        DefaultExecutionDeploymentTracker tracker = new DefaultExecutionDeploymentTracker();
        ExecutionAttemptID attemptId1 = ExecutionGraphTestUtils.createExecutionAttemptId();
        ResourceID resourceId1 = ResourceID.generate();
        tracker.startTrackingPendingDeploymentOf(attemptId1, resourceId1);
        tracker.completeDeploymentOf(attemptId1);
        tracker.stopTrackingDeploymentOf(ExecutionGraphTestUtils.createExecutionAttemptId());
        Assertions.assertThat((Map)tracker.getExecutionsOn(resourceId1)).containsKey((Object)attemptId1);
    }

    @Test
    void testCompleteDeploymentUnknownExecutionDoesNotThrowException() {
        DefaultExecutionDeploymentTracker tracker = new DefaultExecutionDeploymentTracker();
        tracker.completeDeploymentOf(ExecutionGraphTestUtils.createExecutionAttemptId());
    }

    @Test
    void testStopTrackingUnknownExecutionDoesNotThrowException() {
        DefaultExecutionDeploymentTracker tracker = new DefaultExecutionDeploymentTracker();
        ExecutionAttemptID attemptId2 = ExecutionGraphTestUtils.createExecutionAttemptId();
        tracker.stopTrackingDeploymentOf(attemptId2);
    }

    @Test
    void testGetExecutionsReturnsEmptySetForUnknownHost() {
        DefaultExecutionDeploymentTracker tracker = new DefaultExecutionDeploymentTracker();
        Assertions.assertThat(tracker.getExecutionsOn(ResourceID.generate()).entrySet()).isEmpty();
    }
}

