/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.iterative.event;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.flink.api.common.aggregators.Aggregator;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.runtime.iterative.event.AllWorkersDoneEvent;
import org.apache.flink.runtime.iterative.event.IterationEventWithAggregators;
import org.apache.flink.types.LongValue;
import org.apache.flink.types.StringValue;
import org.apache.flink.types.Value;
import org.junit.Assert;
import org.junit.Test;

public class EventWithAggregatorsTest {
    private ClassLoader cl = ClassLoader.getSystemClassLoader();

    @Test
    public void testSerializationOfEmptyEvent() {
        AllWorkersDoneEvent e = new AllWorkersDoneEvent();
        IterationEventWithAggregators deserialized = this.pipeThroughSerialization((IterationEventWithAggregators)e);
        Assert.assertEquals((long)0L, (long)deserialized.getAggregatorNames().length);
        Assert.assertEquals((long)0L, (long)deserialized.getAggregates(this.cl).length);
    }

    @Test
    public void testSerializationOfEventWithAggregateValues() {
        StringValue stringValue = new StringValue((CharSequence)"test string");
        LongValue longValue = new LongValue(68743254L);
        String stringValueName = "stringValue";
        String longValueName = "longValue";
        TestAggregator<StringValue> stringAgg = new TestAggregator<StringValue>(stringValue);
        TestAggregator<LongValue> longAgg = new TestAggregator<LongValue>(longValue);
        HashMap<String, TestAggregator<Object>> aggMap = new HashMap<String, TestAggregator<Object>>();
        aggMap.put(stringValueName, stringAgg);
        aggMap.put(longValueName, longAgg);
        HashSet<String> allNames = new HashSet<String>();
        allNames.add(stringValueName);
        allNames.add(longValueName);
        HashSet<Object> allVals = new HashSet<Object>();
        allVals.add(stringValue);
        allVals.add(longValue);
        AllWorkersDoneEvent e = new AllWorkersDoneEvent(aggMap);
        IterationEventWithAggregators deserialized = this.pipeThroughSerialization((IterationEventWithAggregators)e);
        String[] names = deserialized.getAggregatorNames();
        Value[] aggregates = deserialized.getAggregates(this.cl);
        Assert.assertEquals((long)allNames.size(), (long)names.length);
        Assert.assertEquals((long)allVals.size(), (long)aggregates.length);
        for (String string : names) {
            allNames.remove(string);
        }
        for (String string : aggregates) {
            allVals.remove(string);
        }
        Assert.assertTrue((boolean)allNames.isEmpty());
        Assert.assertTrue((boolean)allVals.isEmpty());
    }

    private IterationEventWithAggregators pipeThroughSerialization(IterationEventWithAggregators event) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            event.write((DataOutputView)new DataOutputViewStreamWrapper((OutputStream)baos));
            byte[] data = baos.toByteArray();
            baos.close();
            DataInputViewStreamWrapper in = new DataInputViewStreamWrapper((InputStream)new ByteArrayInputStream(data));
            IterationEventWithAggregators newEvent = (IterationEventWithAggregators)event.getClass().newInstance();
            newEvent.read((DataInputView)in);
            in.close();
            return newEvent;
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assert.fail((String)("Test threw an exception: " + e.getMessage()));
            return null;
        }
    }

    private static class TestAggregator<T extends Value>
    implements Aggregator<T> {
        private static final long serialVersionUID = 1L;
        private final T val;

        public TestAggregator(T val) {
            this.val = val;
        }

        public T getAggregate() {
            return this.val;
        }

        public void aggregate(T element) {
            throw new UnsupportedOperationException();
        }

        public void reset() {
            throw new UnsupportedOperationException();
        }
    }
}

