/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid.tiered.netty;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferBuilderTestUtils;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.netty.NettyConnectionWriter;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.netty.NettyConnectionWriterImpl;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.netty.NettyPayload;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.netty.NettyPayloadManager;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class NettyConnectionWriterTest {
    private static final int SUBPARTITION_ID = 0;

    NettyConnectionWriterTest() {
    }

    @Test
    void testWriteBuffer() {
        int bufferNumber = 10;
        NettyPayloadManager nettyPayloadManager = new NettyPayloadManager();
        NettyConnectionWriterImpl nettyConnectionWriter = new NettyConnectionWriterImpl(nettyPayloadManager);
        NettyConnectionWriterTest.writeBufferToWriter(bufferNumber, (NettyConnectionWriter)nettyConnectionWriter);
        Assertions.assertThat((int)nettyPayloadManager.getBacklog()).isEqualTo(bufferNumber);
        Assertions.assertThat((int)nettyConnectionWriter.numQueuedPayloads()).isEqualTo(bufferNumber);
        Assertions.assertThat((int)nettyConnectionWriter.numQueuedBufferPayloads()).isEqualTo(bufferNumber);
    }

    @Test
    void testGetNettyConnectionId() {
        NettyConnectionWriterImpl nettyConnectionWriter = new NettyConnectionWriterImpl(new NettyPayloadManager());
        Assertions.assertThat((Object)nettyConnectionWriter.getNettyConnectionId()).isNotNull();
    }

    @Test
    void testNotifyAvailable() {
        CompletableFuture notifier = new CompletableFuture();
        NettyConnectionWriterImpl nettyConnectionWriter = new NettyConnectionWriterImpl(new NettyPayloadManager());
        nettyConnectionWriter.registerAvailabilityListener(() -> notifier.complete(null));
        nettyConnectionWriter.notifyAvailable();
        Assertions.assertThat(notifier).isDone();
    }

    @Test
    void testClose() {
        int bufferNumber = 10;
        NettyConnectionWriterImpl nettyConnectionWriter = new NettyConnectionWriterImpl(new NettyPayloadManager());
        NettyConnectionWriterTest.writeBufferToWriter(bufferNumber, (NettyConnectionWriter)nettyConnectionWriter);
        nettyConnectionWriter.close(null);
        Assertions.assertThat((int)nettyConnectionWriter.numQueuedPayloads()).isZero();
        Assertions.assertThat((int)nettyConnectionWriter.numQueuedBufferPayloads()).isZero();
        NettyConnectionWriterTest.writeBufferToWriter(bufferNumber, (NettyConnectionWriter)nettyConnectionWriter);
        nettyConnectionWriter.close((Throwable)new IOException());
        Assertions.assertThat((int)nettyConnectionWriter.numQueuedPayloads()).isOne();
        Assertions.assertThat((int)nettyConnectionWriter.numQueuedBufferPayloads()).isZero();
    }

    @Test
    void testGetNumQueuedBufferPayloads() {
        NettyPayloadManager nettyPayloadManager = new NettyPayloadManager();
        NettyConnectionWriterImpl nettyConnectionWriter = new NettyConnectionWriterImpl(nettyPayloadManager);
        nettyConnectionWriter.writeNettyPayload(NettyPayload.newSegment((int)0));
        NettyConnectionWriterTest.writeBufferToWriter(3, (NettyConnectionWriter)nettyConnectionWriter);
        nettyConnectionWriter.writeNettyPayload(NettyPayload.newSegment((int)2));
        NettyConnectionWriterTest.writeBufferToWriter(1, (NettyConnectionWriter)nettyConnectionWriter);
        nettyConnectionWriter.writeNettyPayload(NettyPayload.newSegment((int)3));
        NettyConnectionWriterTest.writeBufferToWriter(1, (NettyConnectionWriter)nettyConnectionWriter);
        nettyConnectionWriter.writeNettyPayload(NettyPayload.newSegment((int)5));
        NettyConnectionWriterTest.writeBufferToWriter(5, (NettyConnectionWriter)nettyConnectionWriter);
        Assertions.assertThat((int)nettyConnectionWriter.numQueuedBufferPayloads()).isEqualTo(3);
        NettyConnectionWriterTest.clearNettyPayloadManager(1, nettyPayloadManager);
        Assertions.assertThat((int)nettyConnectionWriter.numQueuedBufferPayloads()).isEqualTo(3);
        NettyConnectionWriterTest.clearNettyPayloadManager(2, nettyPayloadManager);
        Assertions.assertThat((int)nettyConnectionWriter.numQueuedBufferPayloads()).isEqualTo(1);
        NettyConnectionWriterTest.clearNettyPayloadManager(1, nettyPayloadManager);
        Assertions.assertThat((int)nettyConnectionWriter.numQueuedBufferPayloads()).isEqualTo(2);
        NettyConnectionWriterTest.clearNettyPayloadManager(1, nettyPayloadManager);
        Assertions.assertThat((int)nettyConnectionWriter.numQueuedBufferPayloads()).isEqualTo(2);
        NettyConnectionWriterTest.clearNettyPayloadManager(1, nettyPayloadManager);
        Assertions.assertThat((int)nettyConnectionWriter.numQueuedBufferPayloads()).isEqualTo(1);
        NettyConnectionWriterTest.clearNettyPayloadManager(1, nettyPayloadManager);
        Assertions.assertThat((int)nettyConnectionWriter.numQueuedBufferPayloads()).isEqualTo(1);
        NettyConnectionWriterTest.clearNettyPayloadManager(1, nettyPayloadManager);
        Assertions.assertThat((int)nettyConnectionWriter.numQueuedBufferPayloads()).isEqualTo(5);
        NettyConnectionWriterTest.clearNettyPayloadManager(1, nettyPayloadManager);
        Assertions.assertThat((int)nettyConnectionWriter.numQueuedBufferPayloads()).isEqualTo(5);
        NettyConnectionWriterTest.clearNettyPayloadManager(2, nettyPayloadManager);
        Assertions.assertThat((int)nettyConnectionWriter.numQueuedBufferPayloads()).isEqualTo(3);
    }

    private static void writeBufferToWriter(int bufferNumber, NettyConnectionWriter nettyConnectionWriter) {
        for (int index = 0; index < bufferNumber; ++index) {
            nettyConnectionWriter.writeNettyPayload(NettyPayload.newBuffer((Buffer)BufferBuilderTestUtils.buildSomeBuffer(0), (int)index, (int)0));
        }
    }

    private static void clearNettyPayloadManager(int payloadNumber, NettyPayloadManager nettyPayloadManager) {
        for (int index = 0; index < payloadNumber; ++index) {
            nettyPayloadManager.poll();
        }
    }
}

