/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.flink.runtime.checkpoint.StateObjectCollection;
import org.apache.flink.runtime.state.StateObject;
import org.apache.flink.util.MethodForwardingTestUtil;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class StateObjectCollectionTest {
    StateObjectCollectionTest() {
    }

    @Test
    void testEmptyCollection() {
        StateObjectCollection empty = StateObjectCollection.empty();
        Assertions.assertThat((long)empty.getStateSize()).isZero();
    }

    @Test
    void testForwardingCollectionMethods() throws Exception {
        MethodForwardingTestUtil.testMethodForwarding(Collection.class, StateObjectCollection::new);
    }

    @Test
    void testForwardingStateObjectMethods() throws Exception {
        MethodForwardingTestUtil.testMethodForwarding(StateObject.class, object -> new StateObjectCollection(Collections.singletonList(object)));
    }

    @Test
    void testHasState() {
        StateObjectCollection stateObjects = new StateObjectCollection(new ArrayList());
        Assertions.assertThat((boolean)stateObjects.hasState()).isFalse();
        stateObjects = new StateObjectCollection(Collections.singletonList(null));
        Assertions.assertThat((boolean)stateObjects.hasState()).isFalse();
        stateObjects = new StateObjectCollection(Collections.singletonList((StateObject)Mockito.mock(StateObject.class)));
        Assertions.assertThat((boolean)stateObjects.hasState()).isTrue();
    }
}

