/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.io.NotSerializableException;
import java.io.Serializable;
import java.util.HashMap;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.runtime.checkpoint.CheckpointProperties;
import org.apache.flink.runtime.checkpoint.CheckpointRetentionPolicy;
import org.apache.flink.runtime.checkpoint.FailedCheckpointStats;
import org.apache.flink.runtime.checkpoint.TaskStateStats;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class FailedCheckpointStatsTest {
    @Test
    void testEndToEndDuration() {
        long duration = 123912931293L;
        long triggerTimestamp = 10123L;
        long failureTimestamp = triggerTimestamp + duration;
        HashMap<JobVertexID, TaskStateStats> taskStats = new HashMap<JobVertexID, TaskStateStats>();
        JobVertexID jobVertexId = new JobVertexID();
        taskStats.put(jobVertexId, new TaskStateStats(jobVertexId, 1));
        FailedCheckpointStats failed = new FailedCheckpointStats(0L, triggerTimestamp, CheckpointProperties.forCheckpoint((CheckpointRetentionPolicy)CheckpointRetentionPolicy.NEVER_RETAIN_AFTER_TERMINATION), 1, taskStats, 0, 0L, 0L, 0L, 0L, false, failureTimestamp, null, null);
        Assertions.assertThat((long)failed.getEndToEndDuration()).isEqualTo(duration);
    }

    @Test
    void testIsJavaSerializable() throws Exception {
        long duration = 123912931293L;
        long triggerTimestamp = 10123L;
        long failureTimestamp = triggerTimestamp + duration;
        HashMap<JobVertexID, TaskStateStats> taskStats = new HashMap<JobVertexID, TaskStateStats>();
        JobVertexID jobVertexId = new JobVertexID();
        taskStats.put(jobVertexId, new TaskStateStats(jobVertexId, 1));
        FailedCheckpointStats failed = new FailedCheckpointStats(123123123L, triggerTimestamp, CheckpointProperties.forCheckpoint((CheckpointRetentionPolicy)CheckpointRetentionPolicy.NEVER_RETAIN_AFTER_TERMINATION), 1337, taskStats, 3, 190890123L, 190890123L, 4242L, 4444L, true, failureTimestamp, null, (Throwable)new NotSerializableException("message"));
        FailedCheckpointStats copy = (FailedCheckpointStats)CommonTestUtils.createCopySerializable((Serializable)failed);
        Assertions.assertThat((long)copy.getCheckpointId()).isEqualTo(failed.getCheckpointId());
        Assertions.assertThat((long)copy.getTriggerTimestamp()).isEqualTo(failed.getTriggerTimestamp());
        Assertions.assertThat((Object)copy.getProperties()).isEqualTo((Object)failed.getProperties());
        Assertions.assertThat((int)copy.getNumberOfSubtasks()).isEqualTo(failed.getNumberOfSubtasks());
        Assertions.assertThat((int)copy.getNumberOfAcknowledgedSubtasks()).isEqualTo(failed.getNumberOfAcknowledgedSubtasks());
        Assertions.assertThat((long)copy.getEndToEndDuration()).isEqualTo(failed.getEndToEndDuration());
        Assertions.assertThat((long)copy.getStateSize()).isEqualTo(failed.getStateSize());
        Assertions.assertThat((long)copy.getProcessedData()).isEqualTo(failed.getProcessedData());
        Assertions.assertThat((long)copy.getPersistedData()).isEqualTo(failed.getPersistedData());
        Assertions.assertThat((boolean)copy.isUnalignedCheckpoint()).isEqualTo(failed.isUnalignedCheckpoint());
        Assertions.assertThat((Object)copy.getLatestAcknowledgedSubtaskStats()).isEqualTo((Object)failed.getLatestAcknowledgedSubtaskStats());
        Assertions.assertThat((Comparable)copy.getStatus()).isEqualTo((Object)failed.getStatus());
        Assertions.assertThat((String)copy.getFailureMessage()).isEqualTo(failed.getFailureMessage());
    }
}

