/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.IOException;
import java.io.InputStream;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.runtime.state.StreamCompressionDecorator;
import org.apache.flink.runtime.state.UncompressedStreamCompressionDecorator;

public class CompressibleFSDataInputStream
extends FSDataInputStream {
    private final FSDataInputStream delegate;
    private final InputStream compressingDelegate;
    private final boolean compressed;

    public CompressibleFSDataInputStream(FSDataInputStream delegate, StreamCompressionDecorator compressionDecorator) throws IOException {
        this.delegate = delegate;
        this.compressingDelegate = compressionDecorator.decorateWithCompression((InputStream)delegate);
        this.compressed = compressionDecorator != UncompressedStreamCompressionDecorator.INSTANCE;
    }

    public void seek(long desired) throws IOException {
        int available;
        if (this.compressed && (available = this.compressingDelegate.available()) > 0 && (long)available != this.compressingDelegate.skip(available)) {
            throw new IOException("Unable to skip buffered data.");
        }
        this.delegate.seek(desired);
    }

    public long getPos() throws IOException {
        return this.delegate.getPos();
    }

    public int read() throws IOException {
        return this.compressingDelegate.read();
    }

    public void close() throws IOException {
        this.compressingDelegate.close();
    }
}

