/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.sort;

import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.runtime.operators.sort.PartialOrderPriorityQueue;
import org.apache.flink.util.MutableObjectIterator;

public class MergeIterator<E>
implements MutableObjectIterator<E> {
    private final PartialOrderPriorityQueue<HeadStream<E>> heap;

    public MergeIterator(List<MutableObjectIterator<E>> iterators, TypeComparator<E> comparator) throws IOException {
        this.heap = new PartialOrderPriorityQueue(new HeadStreamComparator(), iterators.size());
        for (MutableObjectIterator<E> iterator : iterators) {
            this.heap.add(new HeadStream<E>(iterator, comparator.duplicate()));
        }
    }

    public E next(E reuse) throws IOException {
        if (this.heap.size() > 0) {
            HeadStream<E> top = this.heap.peek();
            E result = top.getHead();
            if (!top.nextHead(reuse)) {
                this.heap.poll();
            } else {
                this.heap.adjustTop();
            }
            return result;
        }
        return null;
    }

    public E next() throws IOException {
        if (this.heap.size() > 0) {
            HeadStream<E> top = this.heap.peek();
            E result = top.getHead();
            if (!top.nextHead()) {
                this.heap.poll();
            } else {
                this.heap.adjustTop();
            }
            return result;
        }
        return null;
    }

    private static final class HeadStreamComparator<E>
    implements Comparator<HeadStream<E>> {
        private HeadStreamComparator() {
        }

        @Override
        public int compare(HeadStream<E> o1, HeadStream<E> o2) {
            return o2.comparator.compareToReference(o1.comparator);
        }
    }

    private static final class HeadStream<E> {
        private final MutableObjectIterator<E> iterator;
        private final TypeComparator<E> comparator;
        private E head;

        public HeadStream(MutableObjectIterator<E> iterator, TypeComparator<E> comparator) throws IOException {
            this.iterator = iterator;
            this.comparator = comparator;
            if (!this.nextHead()) {
                throw new IllegalStateException();
            }
        }

        public E getHead() {
            return this.head;
        }

        public boolean nextHead(E reuse) throws IOException {
            this.head = this.iterator.next(reuse);
            if (this.head != null) {
                this.comparator.setReference(this.head);
                return true;
            }
            return false;
        }

        public boolean nextHead() throws IOException {
            this.head = this.iterator.next();
            if (this.head != null) {
                this.comparator.setReference(this.head);
                return true;
            }
            return false;
        }
    }
}

