/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.groups;

import java.util.Collections;
import java.util.Map;
import org.apache.flink.metrics.CharacterFilter;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.dump.QueryScopeInfo;
import org.apache.flink.runtime.metrics.groups.ComponentMetricGroup;
import org.apache.flink.runtime.metrics.groups.JobManagerJobMetricGroup;
import org.apache.flink.runtime.metrics.scope.ScopeFormat;
import org.apache.flink.util.AbstractID;
import org.apache.flink.util.Preconditions;

public class JobManagerOperatorMetricGroup
extends ComponentMetricGroup<JobManagerJobMetricGroup> {
    private final AbstractID vertexId;
    private final String taskName;
    private final String operatorName;
    private final OperatorID operatorID;

    public JobManagerOperatorMetricGroup(MetricRegistry registry, JobManagerJobMetricGroup parent, AbstractID vertexId, String taskName, OperatorID operatorID, String operatorName) {
        super(registry, registry.getScopeFormats().getJmOperatorFormat().formatScope((JobManagerJobMetricGroup)Preconditions.checkNotNull((Object)parent), vertexId, taskName, operatorID, operatorName), parent);
        this.vertexId = vertexId;
        this.taskName = taskName;
        this.operatorID = operatorID;
        this.operatorName = operatorName;
    }

    @Override
    protected String getGroupName(CharacterFilter filter) {
        return "operator";
    }

    @Override
    protected QueryScopeInfo.JobManagerOperatorQueryScopeInfo createQueryServiceMetricInfo(CharacterFilter filter) {
        return new QueryScopeInfo.JobManagerOperatorQueryScopeInfo(((JobManagerJobMetricGroup)this.parent).jobId.toString(), this.vertexId.toString(), filter.filterCharacters(this.operatorName));
    }

    @Override
    protected void putVariables(Map<String, String> variables) {
        variables.put(ScopeFormat.SCOPE_TASK_VERTEX_ID, this.vertexId.toString());
        variables.put(ScopeFormat.SCOPE_TASK_NAME, this.taskName);
        variables.put(ScopeFormat.SCOPE_OPERATOR_ID, String.valueOf((Object)this.operatorID));
        variables.put(ScopeFormat.SCOPE_OPERATOR_NAME, this.operatorName);
    }

    @Override
    public void close() {
        super.close();
        ((JobManagerJobMetricGroup)this.parent).removeOperatorMetricGroup(this.operatorID, this.operatorName);
    }

    @Override
    protected Iterable<? extends ComponentMetricGroup> subComponents() {
        return Collections.emptyList();
    }
}

