/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobgraph.forwardgroup;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.jobgraph.forwardgroup.ForwardGroup;
import org.apache.flink.runtime.jobgraph.forwardgroup.ForwardGroupComputeUtil;
import org.apache.flink.streaming.api.graph.StreamNode;
import org.apache.flink.util.Preconditions;

public class StreamNodeForwardGroup
implements ForwardGroup<Integer> {
    private int parallelism = -1;
    private int maxParallelism = -1;
    private final Set<StreamNode> streamNodes = new HashSet<StreamNode>();

    public StreamNodeForwardGroup(Set<StreamNode> streamNodes) {
        Set configuredMaxParallelisms;
        Preconditions.checkNotNull(streamNodes);
        Set configuredParallelisms = streamNodes.stream().map(StreamNode::getParallelism).filter(v -> v > 0).collect(Collectors.toSet());
        Preconditions.checkState((configuredParallelisms.size() <= 1 ? 1 : 0) != 0);
        if (configuredParallelisms.size() == 1) {
            this.parallelism = (Integer)configuredParallelisms.iterator().next();
        }
        if (!(configuredMaxParallelisms = streamNodes.stream().map(StreamNode::getMaxParallelism).filter(val -> val > 0).collect(Collectors.toSet())).isEmpty()) {
            this.maxParallelism = (Integer)Collections.min(configuredMaxParallelisms);
            Preconditions.checkState((this.parallelism == -1 || this.maxParallelism >= this.parallelism ? 1 : 0) != 0, (Object)"There is a start node in the forward group whose maximum parallelism is smaller than the group's parallelism");
        }
        this.streamNodes.addAll(streamNodes);
    }

    @Override
    public void setParallelism(int parallelism) {
        Preconditions.checkState((this.parallelism == -1 ? 1 : 0) != 0);
        this.parallelism = parallelism;
        this.streamNodes.forEach(streamNode -> streamNode.setParallelism(parallelism));
    }

    @Override
    public boolean isParallelismDecided() {
        return this.parallelism > 0;
    }

    @Override
    public int getParallelism() {
        Preconditions.checkState((boolean)this.isParallelismDecided());
        return this.parallelism;
    }

    @Override
    public void setMaxParallelism(int maxParallelism) {
        Preconditions.checkState((maxParallelism == -1 || maxParallelism >= this.parallelism ? 1 : 0) != 0, (Object)"There is a job vertex in the forward group whose maximum parallelism is smaller than the group's parallelism");
        this.maxParallelism = maxParallelism;
        this.streamNodes.forEach(streamNode -> streamNode.setMaxParallelism(maxParallelism));
    }

    @Override
    public boolean isMaxParallelismDecided() {
        return this.maxParallelism > 0;
    }

    @Override
    public int getMaxParallelism() {
        Preconditions.checkState((boolean)this.isMaxParallelismDecided());
        return this.maxParallelism;
    }

    @Override
    public Set<Integer> getVertexIds() {
        return this.streamNodes.stream().map(StreamNode::getId).collect(Collectors.toSet());
    }

    public boolean mergeForwardGroup(StreamNodeForwardGroup forwardGroupToMerge) {
        Preconditions.checkNotNull((Object)forwardGroupToMerge);
        if (forwardGroupToMerge == this) {
            return true;
        }
        if (!ForwardGroupComputeUtil.canTargetMergeIntoSourceForwardGroup(this, forwardGroupToMerge)) {
            return false;
        }
        if (this.isParallelismDecided() && !forwardGroupToMerge.isParallelismDecided()) {
            forwardGroupToMerge.setParallelism(this.parallelism);
        } else if (!this.isParallelismDecided() && forwardGroupToMerge.isParallelismDecided()) {
            this.setParallelism(forwardGroupToMerge.parallelism);
        } else {
            Preconditions.checkState((this.parallelism == forwardGroupToMerge.parallelism ? 1 : 0) != 0);
        }
        if (forwardGroupToMerge.isMaxParallelismDecided() && (!this.isMaxParallelismDecided() || this.maxParallelism > forwardGroupToMerge.maxParallelism)) {
            this.setMaxParallelism(forwardGroupToMerge.maxParallelism);
        } else if (this.isMaxParallelismDecided() && (!forwardGroupToMerge.isMaxParallelismDecided() || forwardGroupToMerge.maxParallelism > this.maxParallelism)) {
            forwardGroupToMerge.setMaxParallelism(this.maxParallelism);
        } else {
            Preconditions.checkState((this.maxParallelism == forwardGroupToMerge.maxParallelism ? 1 : 0) != 0);
        }
        this.streamNodes.addAll(forwardGroupToMerge.streamNodes);
        return true;
    }

    @VisibleForTesting
    public int size() {
        return this.streamNodes.size();
    }
}

