/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.StateRecoveryOptions;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.runtime.jobgraph.JobType;
import org.apache.flink.runtime.jobmaster.slotpool.LocationPreferenceSlotSelectionStrategy;
import org.apache.flink.runtime.jobmaster.slotpool.PreviousAllocationSlotSelectionStrategy;
import org.apache.flink.runtime.jobmaster.slotpool.SlotSelectionStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlotSelectionStrategyUtils {
    private static final Logger LOG = LoggerFactory.getLogger(SlotSelectionStrategyUtils.class);

    public static SlotSelectionStrategy selectSlotSelectionStrategy(JobType jobType, Configuration configuration) {
        TaskManagerOptions.TaskManagerLoadBalanceMode taskManagerLoadBalanceMode = (TaskManagerOptions.TaskManagerLoadBalanceMode)configuration.get(TaskManagerOptions.TASK_MANAGER_LOAD_BALANCE_MODE);
        LocationPreferenceSlotSelectionStrategy locationPreferenceSlotSelectionStrategy = taskManagerLoadBalanceMode == TaskManagerOptions.TaskManagerLoadBalanceMode.SLOTS ? LocationPreferenceSlotSelectionStrategy.createEvenlySpreadOut() : LocationPreferenceSlotSelectionStrategy.createDefault();
        boolean isLocalRecoveryEnabled = (Boolean)configuration.get(StateRecoveryOptions.LOCAL_RECOVERY);
        if (isLocalRecoveryEnabled) {
            if (jobType == JobType.STREAMING) {
                return PreviousAllocationSlotSelectionStrategy.create(locationPreferenceSlotSelectionStrategy);
            }
            LOG.warn("Batch job does not support local recovery. Falling back to use " + locationPreferenceSlotSelectionStrategy.getClass());
            return locationPreferenceSlotSelectionStrategy;
        }
        return locationPreferenceSlotSelectionStrategy;
    }

    private SlotSelectionStrategyUtils() {
    }
}

