/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.execution.librarycache.LibraryCacheManager;
import org.apache.flink.runtime.jobmaster.JobMasterGateway;
import org.apache.flink.runtime.jobmaster.JobMasterId;
import org.apache.flink.runtime.taskexecutor.GlobalAggregateManager;
import org.apache.flink.runtime.taskexecutor.JobTable;
import org.apache.flink.runtime.taskexecutor.PartitionProducerStateChecker;
import org.apache.flink.runtime.taskmanager.CheckpointResponder;
import org.apache.flink.runtime.taskmanager.TaskManagerActions;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.SupplierWithException;

public final class DefaultJobTable
implements JobTable {
    private final Map<JobID, JobOrConnection> jobs = new HashMap<JobID, JobOrConnection>();
    private final Map<ResourceID, JobID> resourceIdJobIdIndex = new HashMap<ResourceID, JobID>();

    private DefaultJobTable() {
    }

    @Override
    public <E extends Exception> JobTable.Job getOrCreateJob(JobID jobId, SupplierWithException<? extends JobTable.JobServices, E> jobServicesSupplier) throws E {
        JobOrConnection job = this.jobs.get(jobId);
        if (job == null) {
            job = new JobOrConnection(jobId, (JobTable.JobServices)jobServicesSupplier.get());
            this.jobs.put(jobId, job);
        }
        return job;
    }

    @Override
    public Optional<JobTable.Job> getJob(JobID jobId) {
        return Optional.ofNullable((JobTable.Job)this.jobs.get(jobId));
    }

    @Override
    public Optional<JobTable.Connection> getConnection(JobID jobId) {
        return this.getJob(jobId).flatMap(JobTable.Job::asConnection);
    }

    @Override
    public Optional<JobTable.Connection> getConnection(ResourceID resourceId) {
        JobID jobId = this.resourceIdJobIdIndex.get(resourceId);
        if (jobId != null) {
            return this.getConnection(jobId);
        }
        return Optional.empty();
    }

    @Override
    public Collection<JobTable.Job> getJobs() {
        return new ArrayList<JobTable.Job>(this.jobs.values());
    }

    @Override
    public boolean isEmpty() {
        return this.jobs.isEmpty();
    }

    public static DefaultJobTable create() {
        return new DefaultJobTable();
    }

    @Override
    public void close() {
        for (JobTable.Job job : this.getJobs()) {
            job.close();
        }
    }

    private static final class EstablishedConnection {
        private final ResourceID resourceID;
        private final JobMasterGateway jobMasterGateway;
        private final TaskManagerActions taskManagerActions;
        private final CheckpointResponder checkpointResponder;
        private final GlobalAggregateManager globalAggregateManager;
        private final PartitionProducerStateChecker partitionStateChecker;

        private EstablishedConnection(ResourceID resourceID, JobMasterGateway jobMasterGateway, TaskManagerActions taskManagerActions, CheckpointResponder checkpointResponder, GlobalAggregateManager globalAggregateManager, PartitionProducerStateChecker partitionStateChecker) {
            this.resourceID = (ResourceID)Preconditions.checkNotNull((Object)resourceID);
            this.jobMasterGateway = (JobMasterGateway)Preconditions.checkNotNull((Object)jobMasterGateway);
            this.taskManagerActions = (TaskManagerActions)Preconditions.checkNotNull((Object)taskManagerActions);
            this.checkpointResponder = (CheckpointResponder)Preconditions.checkNotNull((Object)checkpointResponder);
            this.globalAggregateManager = (GlobalAggregateManager)Preconditions.checkNotNull((Object)globalAggregateManager);
            this.partitionStateChecker = (PartitionProducerStateChecker)Preconditions.checkNotNull((Object)partitionStateChecker);
        }

        public ResourceID getResourceID() {
            return this.resourceID;
        }

        public JobMasterId getJobMasterId() {
            return (JobMasterId)((Object)this.jobMasterGateway.getFencingToken());
        }

        public JobMasterGateway getJobMasterGateway() {
            return this.jobMasterGateway;
        }

        public TaskManagerActions getTaskManagerActions() {
            return this.taskManagerActions;
        }

        public CheckpointResponder getCheckpointResponder() {
            return this.checkpointResponder;
        }

        public GlobalAggregateManager getGlobalAggregateManager() {
            return this.globalAggregateManager;
        }

        public PartitionProducerStateChecker getPartitionStateChecker() {
            return this.partitionStateChecker;
        }
    }

    private final class JobOrConnection
    implements JobTable.Job,
    JobTable.Connection {
        private final JobID jobId;
        private final JobTable.JobServices jobServices;
        @Nullable
        private EstablishedConnection connection;
        private boolean isClosed;

        private JobOrConnection(JobID jobId, JobTable.JobServices jobServices) {
            this.jobId = jobId;
            this.jobServices = jobServices;
            this.connection = null;
            this.isClosed = false;
        }

        @Override
        public boolean isConnected() {
            this.verifyJobIsNotClosed();
            return this.connection != null;
        }

        @Override
        public JobTable.Job disconnect() {
            DefaultJobTable.this.resourceIdJobIdIndex.remove(this.verifyContainsEstablishedConnection().getResourceID());
            this.connection = null;
            return this;
        }

        @Override
        public JobMasterId getJobMasterId() {
            return this.verifyContainsEstablishedConnection().getJobMasterId();
        }

        @Override
        public JobMasterGateway getJobManagerGateway() {
            return this.verifyContainsEstablishedConnection().getJobMasterGateway();
        }

        @Override
        public TaskManagerActions getTaskManagerActions() {
            return this.verifyContainsEstablishedConnection().getTaskManagerActions();
        }

        @Override
        public CheckpointResponder getCheckpointResponder() {
            return this.verifyContainsEstablishedConnection().getCheckpointResponder();
        }

        @Override
        public GlobalAggregateManager getGlobalAggregateManager() {
            return this.verifyContainsEstablishedConnection().getGlobalAggregateManager();
        }

        @Override
        public LibraryCacheManager.ClassLoaderHandle getClassLoaderHandle() {
            this.verifyJobIsNotClosed();
            return this.jobServices.getClassLoaderHandle();
        }

        @Override
        public PartitionProducerStateChecker getPartitionStateChecker() {
            return this.verifyContainsEstablishedConnection().getPartitionStateChecker();
        }

        @Override
        public JobID getJobId() {
            return this.jobId;
        }

        @Override
        public ResourceID getResourceId() {
            return this.verifyContainsEstablishedConnection().getResourceID();
        }

        @Override
        public Optional<JobTable.Connection> asConnection() {
            this.verifyJobIsNotClosed();
            if (this.connection != null) {
                return Optional.of(this);
            }
            return Optional.empty();
        }

        @Override
        public JobTable.Connection connect(ResourceID resourceId, JobMasterGateway jobMasterGateway, TaskManagerActions taskManagerActions, CheckpointResponder checkpointResponder, GlobalAggregateManager aggregateManager, PartitionProducerStateChecker partitionStateChecker) {
            this.verifyJobIsNotClosed();
            Preconditions.checkState((this.connection == null ? 1 : 0) != 0);
            this.connection = new EstablishedConnection(resourceId, jobMasterGateway, taskManagerActions, checkpointResponder, aggregateManager, partitionStateChecker);
            DefaultJobTable.this.resourceIdJobIdIndex.put(resourceId, this.jobId);
            return this;
        }

        @Override
        public void close() {
            if (!this.isClosed) {
                if (this.isConnected()) {
                    this.disconnect();
                }
                this.jobServices.close();
                DefaultJobTable.this.jobs.remove(this.jobId);
                this.isClosed = true;
            }
        }

        private void verifyJobIsNotClosed() {
            Preconditions.checkState((!this.isClosed ? 1 : 0) != 0, (Object)"The job has been closed.");
        }

        private EstablishedConnection verifyContainsEstablishedConnection() {
            this.verifyJobIsNotClosed();
            Preconditions.checkState((this.connection != null ? 1 : 0) != 0, (Object)"The job has not been connected to a JobManager.");
            return this.connection;
        }
    }
}

