/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.v2.adaptor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.flink.api.common.state.v2.StateFuture;
import org.apache.flink.api.common.state.v2.StateIterator;
import org.apache.flink.core.state.StateFutureUtils;

public class CompleteStateIterator<T>
implements StateIterator<T> {
    final Iterator<T> iterator;
    final boolean empty;

    CompleteStateIterator(Iterable<T> iterable) {
        this.iterator = iterable.iterator();
        this.empty = !this.iterator.hasNext();
    }

    public <U> StateFuture<Collection<U>> onNext(Function<T, StateFuture<? extends U>> iterating) {
        if (this.isEmpty()) {
            return StateFutureUtils.completedFuture(Collections.emptyList());
        }
        ArrayList resultFutures = new ArrayList();
        this.iterator.forEachRemaining(item -> resultFutures.add((StateFuture)iterating.apply(item)));
        return StateFutureUtils.combineAll(resultFutures);
    }

    public StateFuture<Void> onNext(Consumer<T> iterating) {
        this.iterator.forEachRemaining(iterating);
        return StateFutureUtils.completedVoidFuture();
    }

    public boolean isEmpty() {
        return this.empty;
    }
}

