/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.testutils;

import java.net.URI;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.flink.configuration.CheckpointingOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.configuration.HeartbeatManagerOptions;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.configuration.UnmodifiableConfiguration;
import org.apache.flink.runtime.minicluster.MiniCluster;
import org.apache.flink.runtime.minicluster.MiniClusterConfiguration;
import org.apache.flink.runtime.resourcemanager.ResourceOverview;
import org.apache.flink.runtime.rpc.RpcSystem;
import org.apache.flink.runtime.testutils.CommonTestUtils;
import org.apache.flink.runtime.testutils.MiniClusterResourceConfiguration;
import org.apache.flink.runtime.testutils.PseudoRandomValueSelector;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.Reference;
import org.apache.flink.util.concurrent.FutureUtils;
import org.apache.flink.util.function.SupplierWithException;
import org.junit.rules.ExternalResource;
import org.junit.rules.TemporaryFolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MiniClusterResource
extends ExternalResource {
    private static final boolean RANDOMIZE_BUFFER_DEBLOAT_CONFIG = Boolean.parseBoolean(System.getProperty("buffer-debloat.randomization", "false"));
    private static final MemorySize DEFAULT_MANAGED_MEMORY_SIZE = MemorySize.parse((String)"80m");
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final TemporaryFolder temporaryFolder = new TemporaryFolder();
    private final MiniClusterResourceConfiguration miniClusterResourceConfiguration;
    private MiniCluster miniCluster = null;
    private int numberSlots = -1;
    private UnmodifiableConfiguration restClusterClientConfig;
    private static final RpcSystem rpcSystem = RpcSystem.load();

    public MiniClusterResource(MiniClusterResourceConfiguration miniClusterResourceConfiguration) {
        this.miniClusterResourceConfiguration = (MiniClusterResourceConfiguration)Preconditions.checkNotNull((Object)miniClusterResourceConfiguration);
    }

    public int getNumberSlots() {
        return this.numberSlots;
    }

    public MiniCluster getMiniCluster() {
        return this.miniCluster;
    }

    public UnmodifiableConfiguration getClientConfiguration() {
        return this.restClusterClientConfig;
    }

    @Deprecated
    public URI getRestAddres() {
        return this.getRestAddress();
    }

    public URI getRestAddress() {
        return (URI)this.miniCluster.getRestAddress().join();
    }

    public void before() throws Exception {
        this.temporaryFolder.create();
        this.startMiniCluster();
        this.numberSlots = this.miniClusterResourceConfiguration.getNumberSlotsPerTaskManager() * this.miniClusterResourceConfiguration.getNumberTaskManagers();
    }

    public void cancelAllJobsAndWaitUntilSlotsAreFreed() {
        long shutdownTimeout;
        long heartbeatTimeout = ((Duration)this.miniCluster.getConfiguration().get(HeartbeatManagerOptions.HEARTBEAT_INTERVAL)).toMillis();
        Preconditions.checkState((heartbeatTimeout < (shutdownTimeout = this.miniClusterResourceConfiguration.getShutdownTimeout().toMilliseconds()) ? 1 : 0) != 0, (String)"Heartbeat timeout (%d) needs to be lower than the shutdown timeout (%d) in order to ensure reliable job cancellation and resource cleanup.", (Object[])new Object[]{heartbeatTimeout, shutdownTimeout});
        this.cancelAllJobs(true);
    }

    public void cancelAllJobs() {
        this.cancelAllJobs(false);
    }

    private void cancelAllJobs(boolean waitUntilSlotsAreFreed) {
        try {
            List jobCancellationFutures = ((Collection)this.miniCluster.listJobs().get()).stream().filter(status -> !status.getJobState().isGloballyTerminalState()).map(status -> this.miniCluster.cancelJob(status.getJobId())).collect(Collectors.toList());
            FutureUtils.waitForAll(jobCancellationFutures).get();
            CommonTestUtils.waitUntilCondition((SupplierWithException<Boolean, Exception>)((SupplierWithException)() -> {
                long unfinishedJobs = ((Collection)this.miniCluster.listJobs().get()).stream().filter(status -> !status.getJobState().isGloballyTerminalState()).count();
                return unfinishedJobs == 0L;
            }));
            if (waitUntilSlotsAreFreed) {
                CommonTestUtils.waitUntilCondition((SupplierWithException<Boolean, Exception>)((SupplierWithException)() -> {
                    ResourceOverview resourceOverview = (ResourceOverview)this.miniCluster.getResourceOverview().get();
                    return resourceOverview.getNumberRegisteredSlots() == resourceOverview.getNumberFreeSlots();
                }));
            }
        }
        catch (Exception e) {
            this.log.warn("Exception while shutting down remaining jobs.", (Throwable)e);
        }
    }

    public void after() {
        Exception exception = null;
        if (this.miniCluster != null) {
            this.cancelAllJobs();
            CompletableFuture terminationFuture = this.miniCluster.closeAsync();
            try {
                terminationFuture.get(this.miniClusterResourceConfiguration.getShutdownTimeout().toMilliseconds(), TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                exception = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)e, exception);
            }
            this.miniCluster = null;
        }
        if (exception != null) {
            this.log.warn("Could not properly shut down the MiniClusterResource.", exception);
        }
        this.temporaryFolder.delete();
    }

    private void startMiniCluster() throws Exception {
        Configuration configuration = new Configuration(this.miniClusterResourceConfiguration.getConfiguration());
        configuration.set(CoreOptions.TMP_DIRS, (Object)this.temporaryFolder.newFolder().getAbsolutePath());
        if (!configuration.contains(CheckpointingOptions.CHECKPOINTS_DIRECTORY)) {
            configuration.set(CheckpointingOptions.CHECKPOINTS_DIRECTORY, (Object)this.temporaryFolder.newFolder().toURI().toString());
        }
        if (!configuration.contains(CoreOptions.FILESYTEM_DEFAULT_OVERRIDE)) {
            configuration.set(CoreOptions.FILESYTEM_DEFAULT_OVERRIDE, (Object)true);
        }
        if (!configuration.contains(TaskManagerOptions.MANAGED_MEMORY_SIZE)) {
            configuration.set(TaskManagerOptions.MANAGED_MEMORY_SIZE, (Object)DEFAULT_MANAGED_MEMORY_SIZE);
        }
        configuration.set(JobManagerOptions.PORT, (Object)0);
        if (!configuration.contains(RestOptions.BIND_PORT) && !configuration.contains(RestOptions.PORT)) {
            configuration.set(RestOptions.BIND_PORT, (Object)"0");
        }
        MiniClusterResource.randomizeConfiguration(configuration);
        MiniClusterConfiguration miniClusterConfiguration = new MiniClusterConfiguration.Builder().setConfiguration(configuration).setNumTaskManagers(this.miniClusterResourceConfiguration.getNumberTaskManagers()).setNumSlotsPerTaskManager(this.miniClusterResourceConfiguration.getNumberSlotsPerTaskManager()).setRpcServiceSharing(this.miniClusterResourceConfiguration.getRpcServiceSharing()).setHaServices(this.miniClusterResourceConfiguration.getHaServices()).build();
        this.miniCluster = new MiniCluster(miniClusterConfiguration, () -> Reference.borrowed((Object)rpcSystem));
        this.miniCluster.start();
        URI restAddress = (URI)this.miniCluster.getRestAddress().get();
        this.createClientConfiguration(restAddress);
    }

    private static void randomizeConfiguration(Configuration configuration) {
        if (RANDOMIZE_BUFFER_DEBLOAT_CONFIG && !configuration.contains(TaskManagerOptions.BUFFER_DEBLOAT_ENABLED)) {
            PseudoRandomValueSelector.randomize(configuration, TaskManagerOptions.BUFFER_DEBLOAT_ENABLED, true, false);
        }
    }

    private void createClientConfiguration(URI restAddress) {
        Configuration restClientConfig = new Configuration();
        restClientConfig.set(JobManagerOptions.ADDRESS, (Object)restAddress.getHost());
        restClientConfig.set(RestOptions.PORT, (Object)restAddress.getPort());
        this.restClusterClientConfig = new UnmodifiableConfiguration(restClientConfig);
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> rpcSystem.close()));
    }
}

