/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.v2;

import org.apache.flink.api.common.functions.AggregateFunction;
import org.apache.flink.api.common.state.v2.State;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.runtime.asyncprocessing.StateRequestHandler;
import org.apache.flink.runtime.asyncprocessing.StateRequestType;
import org.apache.flink.runtime.state.v2.AggregatingStateDescriptor;
import org.apache.flink.runtime.state.v2.InternalAggregatingState;
import org.apache.flink.runtime.state.v2.InternalKeyedStateTestBase;
import org.junit.jupiter.api.Test;

class InternalAggregatingStateTest
extends InternalKeyedStateTestBase {
    InternalAggregatingStateTest() {
    }

    @Test
    public void testAggregating() {
        AggregateFunction<Integer, Integer, Integer> aggregator = new AggregateFunction<Integer, Integer, Integer>(){

            public Integer createAccumulator() {
                return 0;
            }

            public Integer add(Integer value, Integer accumulator) {
                return accumulator + value;
            }

            public Integer getResult(Integer accumulator) {
                return accumulator;
            }

            public Integer merge(Integer a, Integer b) {
                return a + b;
            }
        };
        AggregatingStateDescriptor descriptor = new AggregatingStateDescriptor("testAggState", (AggregateFunction)aggregator, (TypeInformation)BasicTypeInfo.INT_TYPE_INFO);
        InternalAggregatingState state = new InternalAggregatingState((StateRequestHandler)this.aec, descriptor);
        this.aec.setCurrentContext(this.aec.buildContext((Object)"test", (Object)"test"));
        state.asyncClear();
        this.validateRequestRun((State)state, StateRequestType.CLEAR, null);
        state.asyncGet();
        this.validateRequestRun((State)state, StateRequestType.AGGREGATING_GET, null);
        state.asyncAdd((Object)1);
        this.validateRequestRun((State)state, StateRequestType.AGGREGATING_ADD, 1);
    }
}

