/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler;

import java.io.IOException;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.concurrent.ComponentMainThreadExecutorServiceAdapter;
import org.apache.flink.runtime.executiongraph.DefaultExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionGraphTestUtils;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.TestingDefaultExecutionGraphBuilder;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.jobgraph.DistributionPattern;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.operators.coordination.TestingOperatorCoordinator;
import org.apache.flink.runtime.scheduler.DefaultOperatorCoordinatorHandler;
import org.apache.flink.testutils.TestingUtils;
import org.apache.flink.testutils.executor.TestExecutorExtension;
import org.apache.flink.util.SerializedValue;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

class DefaultOperatorCoordinatorHandlerTest {
    @RegisterExtension
    private static final TestExecutorExtension<ScheduledExecutorService> EXECUTOR_EXTENSION = TestingUtils.defaultExecutorExtension();

    DefaultOperatorCoordinatorHandlerTest() {
    }

    @Test
    void testRegisterAndStartNewCoordinators() throws Exception {
        JobVertex[] jobVertices = this.createJobVertices(ResultPartitionType.BLOCKING);
        OperatorID operatorId1 = OperatorID.fromJobVertexID((JobVertexID)jobVertices[0].getID());
        OperatorID operatorId2 = OperatorID.fromJobVertexID((JobVertexID)jobVertices[1].getID());
        DefaultExecutionGraph executionGraph = this.createDynamicGraph(jobVertices);
        ExecutionJobVertex ejv1 = executionGraph.getJobVertex(jobVertices[0].getID());
        ExecutionJobVertex ejv2 = executionGraph.getJobVertex(jobVertices[1].getID());
        executionGraph.start(ComponentMainThreadExecutorServiceAdapter.forMainThread());
        executionGraph.initializeJobVertex(ejv1, 0L);
        DefaultOperatorCoordinatorHandler handler = new DefaultOperatorCoordinatorHandler((ExecutionGraph)executionGraph, throwable -> {});
        Assertions.assertThat(handler.getCoordinatorMap().keySet()).contains((Object[])new OperatorID[]{operatorId1});
        executionGraph.initializeJobVertex(ejv2, 0L);
        handler.registerAndStartNewCoordinators(ejv2.getOperatorCoordinators(), executionGraph.getJobMasterMainThreadExecutor(), ejv2.getParallelism());
        Assertions.assertThat(handler.getCoordinatorMap().keySet()).contains((Object[])new OperatorID[]{operatorId1, operatorId2});
    }

    private JobVertex[] createJobVertices(ResultPartitionType resultPartitionType) throws IOException {
        JobVertex[] jobVertices = new JobVertex[2];
        int parallelism = 3;
        jobVertices[0] = ExecutionGraphTestUtils.createNoOpVertex(3);
        jobVertices[1] = ExecutionGraphTestUtils.createNoOpVertex(3);
        jobVertices[1].connectNewDataSetAsInput(jobVertices[0], DistributionPattern.ALL_TO_ALL, resultPartitionType);
        jobVertices[0].addOperatorCoordinator(new SerializedValue((Object)new TestingOperatorCoordinator.Provider(OperatorID.fromJobVertexID((JobVertexID)jobVertices[0].getID()))));
        jobVertices[1].addOperatorCoordinator(new SerializedValue((Object)new TestingOperatorCoordinator.Provider(OperatorID.fromJobVertexID((JobVertexID)jobVertices[1].getID()))));
        return jobVertices;
    }

    private DefaultExecutionGraph createDynamicGraph(JobVertex ... jobVertices) throws Exception {
        return TestingDefaultExecutionGraphBuilder.newBuilder().setJobGraph(new JobGraph(new JobID(), "TestJob", jobVertices)).buildDynamicGraph((ScheduledExecutorService)EXECUTOR_EXTENSION.getExecutor());
    }
}

