/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.taskmanager;

import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.resourcemanager.ResourceManagerGateway;
import org.apache.flink.runtime.resourcemanager.exceptions.UnknownTaskExecutorException;
import org.apache.flink.runtime.resourcemanager.utils.TestingResourceManagerGateway;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.HandlerRequestException;
import org.apache.flink.runtime.rest.handler.taskmanager.TaskManagerProfilingHandler;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.MessageParameters;
import org.apache.flink.runtime.rest.messages.ProfilingInfo;
import org.apache.flink.runtime.rest.messages.RequestBody;
import org.apache.flink.runtime.rest.messages.cluster.ProfilingRequestBody;
import org.apache.flink.runtime.rest.messages.taskmanager.TaskManagerMessageParameters;
import org.apache.flink.runtime.rest.messages.taskmanager.TaskManagerProfilingHeaders;
import org.apache.flink.testutils.TestingUtils;
import org.apache.flink.util.concurrent.FutureUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class TaskManagerProfilingHandlerTest {
    private static final ResourceID EXPECTED_TASK_MANAGER_ID = ResourceID.generate();
    private TestingResourceManagerGateway resourceManagerGateway;
    private TaskManagerProfilingHandler taskManagerProfilingHandler;
    private HandlerRequest<ProfilingRequestBody> handlerRequest;

    TaskManagerProfilingHandlerTest() {
    }

    @BeforeEach
    void setUp(@TempDir Path tempDir) throws HandlerRequestException {
        Configuration clusterConfiguration = new Configuration();
        clusterConfiguration.set(RestOptions.MAX_PROFILING_HISTORY_SIZE, (Object)3);
        clusterConfiguration.set(RestOptions.PROFILING_RESULT_DIR, (Object)tempDir.toString());
        this.resourceManagerGateway = new TestingResourceManagerGateway();
        this.taskManagerProfilingHandler = new TaskManagerProfilingHandler(() -> CompletableFuture.completedFuture(null), TestingUtils.TIMEOUT, Collections.emptyMap(), (MessageHeaders)TaskManagerProfilingHeaders.getInstance(), () -> CompletableFuture.completedFuture(this.resourceManagerGateway), clusterConfiguration);
        this.handlerRequest = TaskManagerProfilingHandlerTest.createRequest(EXPECTED_TASK_MANAGER_ID);
    }

    @Test
    void testGetTaskManagerProfiling() throws Exception {
        ProfilingInfo profilingInfo = ProfilingInfo.create((long)30L, (ProfilingInfo.ProfilingMode)ProfilingInfo.ProfilingMode.ITIMER);
        this.resourceManagerGateway.setRequestProfilingFunction(EXPECTED_TASK_MANAGER_ID -> CompletableFuture.completedFuture(profilingInfo));
        ProfilingInfo profilingInfoResp = (ProfilingInfo)this.taskManagerProfilingHandler.handleRequest(this.handlerRequest, (ResourceManagerGateway)this.resourceManagerGateway).get();
        Assertions.assertThat((Object)profilingInfoResp).isEqualTo((Object)profilingInfo);
    }

    @Test
    void testGetTaskManagerProfilingForUnknownTaskExecutorException() throws Exception {
        this.resourceManagerGateway.setRequestProfilingListFunction(EXPECTED_TASK_MANAGER_ID -> FutureUtils.completedExceptionally((Throwable)new UnknownTaskExecutorException(EXPECTED_TASK_MANAGER_ID)));
        try {
            this.taskManagerProfilingHandler.handleRequest(this.handlerRequest, (ResourceManagerGateway)this.resourceManagerGateway).get();
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            Assertions.assertThat((Throwable)cause).isInstanceOf(UnknownTaskExecutorException.class);
            UnknownTaskExecutorException unknownTaskExecutorException = (UnknownTaskExecutorException)cause;
            Assertions.assertThat((String)unknownTaskExecutorException.getMessage()).contains(new CharSequence[]{"No TaskExecutor registered under " + TaskManagerProfilingHandlerTest.EXPECTED_TASK_MANAGER_ID});
        }
    }

    private static HandlerRequest<ProfilingRequestBody> createRequest(ResourceID taskManagerId) throws HandlerRequestException {
        HashMap<String, String> pathParameters = new HashMap<String, String>();
        pathParameters.put("taskmanagerid", taskManagerId.toString());
        Map queryParameters = Collections.emptyMap();
        ProfilingRequestBody requestBody = new ProfilingRequestBody(ProfilingInfo.ProfilingMode.ITIMER, 10);
        return HandlerRequest.resolveParametersAndCreate((RequestBody)requestBody, (MessageParameters)new TaskManagerMessageParameters(), pathParameters, queryParameters, Collections.emptyList());
    }
}

