/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler;

import java.time.Duration;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.configuration.SchedulerExecutionMode;
import org.apache.flink.configuration.WebOptions;
import org.apache.flink.runtime.rest.handler.RestHandlerConfiguration;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;

class RestHandlerConfigurationTest {
    RestHandlerConfigurationTest() {
    }

    @Test
    void testWebSubmitFeatureFlagEnabled() {
        RestHandlerConfigurationTest.testWebSubmitFeatureFlag(true);
    }

    @Test
    void testWebSubmitFeatureFlagDisabled() {
        RestHandlerConfigurationTest.testWebSubmitFeatureFlag(false);
    }

    @Test
    void testWebCancelFeatureFlagEnabled() {
        RestHandlerConfigurationTest.testWebCancelFeatureFlag(true);
    }

    @Test
    void testWebCancelFeatureFlagDisabled() {
        RestHandlerConfigurationTest.testWebCancelFeatureFlag(false);
    }

    @ParameterizedTest
    @CsvSource(value={"true,true,true,false", "true,true,false,true", "true,false,true,false", "true,false,false,false", "false,true,true,false", "false,true,false,false", "false,false,true,false", "false,false,false,false"})
    void testWebRescaleFeatureFlagWithReactiveMode(boolean webRescaleEnabled, boolean adaptiveScheduler, boolean reactiveMode, boolean expectedResult) {
        Configuration config = new Configuration();
        config.set(WebOptions.RESCALE_ENABLE, (Object)webRescaleEnabled);
        if (adaptiveScheduler) {
            config.set(JobManagerOptions.SCHEDULER, (Object)JobManagerOptions.SchedulerType.Adaptive);
        } else {
            config.set(JobManagerOptions.SCHEDULER, (Object)JobManagerOptions.SchedulerType.Default);
        }
        if (reactiveMode) {
            config.set(JobManagerOptions.SCHEDULER_MODE, (Object)SchedulerExecutionMode.REACTIVE);
        }
        RestHandlerConfiguration restHandlerConfiguration = RestHandlerConfiguration.fromConfiguration((Configuration)config);
        Assertions.assertThat((boolean)restHandlerConfiguration.isWebRescaleEnabled()).isEqualTo(expectedResult);
    }

    private static void testWebSubmitFeatureFlag(boolean webSubmitEnabled) {
        Configuration config = new Configuration();
        config.set(WebOptions.SUBMIT_ENABLE, (Object)webSubmitEnabled);
        RestHandlerConfiguration restHandlerConfiguration = RestHandlerConfiguration.fromConfiguration((Configuration)config);
        Assertions.assertThat((boolean)restHandlerConfiguration.isWebSubmitEnabled()).isEqualTo(webSubmitEnabled);
    }

    private static void testWebCancelFeatureFlag(boolean webCancelEnabled) {
        Configuration config = new Configuration();
        config.set(WebOptions.CANCEL_ENABLE, (Object)webCancelEnabled);
        RestHandlerConfiguration restHandlerConfiguration = RestHandlerConfiguration.fromConfiguration((Configuration)config);
        Assertions.assertThat((boolean)restHandlerConfiguration.isWebCancelEnabled()).isEqualTo(webCancelEnabled);
    }

    @Test
    void testCheckpointCacheExpireAfterWrite() {
        Duration testDuration = Duration.ofMillis(100L);
        Configuration config = new Configuration();
        config.set(RestOptions.CACHE_CHECKPOINT_STATISTICS_TIMEOUT, (Object)testDuration);
        RestHandlerConfiguration restHandlerConfiguration = RestHandlerConfiguration.fromConfiguration((Configuration)config);
        Assertions.assertThat((Duration)restHandlerConfiguration.getCheckpointCacheExpireAfterWrite()).isEqualTo((Object)testDuration);
    }

    @Test
    void testCheckpointCacheExpiryFallbackToRefreshInterval() {
        long refreshInterval = 1000L;
        Configuration config = new Configuration();
        config.set(WebOptions.REFRESH_INTERVAL, (Object)Duration.ofMillis(1000L));
        RestHandlerConfiguration restHandlerConfiguration = RestHandlerConfiguration.fromConfiguration((Configuration)config);
        Assertions.assertThat((Duration)restHandlerConfiguration.getCheckpointCacheExpireAfterWrite()).isEqualTo((Object)Duration.ofMillis(1000L));
    }

    @Test
    void testCheckpointCacheSize() {
        int testCacheSize = 50;
        Configuration config = new Configuration();
        config.set(RestOptions.CACHE_CHECKPOINT_STATISTICS_SIZE, (Object)50);
        RestHandlerConfiguration restHandlerConfiguration = RestHandlerConfiguration.fromConfiguration((Configuration)config);
        Assertions.assertThat((int)restHandlerConfiguration.getCheckpointCacheSize()).isEqualTo(50);
    }
}

