/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.persistence;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import org.apache.flink.runtime.persistence.RetrievableStateStorageHelper;
import org.apache.flink.runtime.state.RetrievableStateHandle;
import org.apache.flink.runtime.state.StateObject;

public class TestingLongStateHandleHelper
implements RetrievableStateStorageHelper<LongStateHandle> {
    private static final List<LongStateHandle> STATE_STORAGE = new ArrayList<LongStateHandle>();

    public RetrievableStateHandle<LongStateHandle> store(LongStateHandle state) {
        int pos = STATE_STORAGE.size();
        STATE_STORAGE.add(state);
        return new LongRetrievableStateHandle(pos);
    }

    public static LongStateHandle createState(long value) {
        return new LongStateHandle(value);
    }

    public static long getStateHandleValueByIndex(int index) {
        return STATE_STORAGE.get(index).getValue();
    }

    public static int getDiscardCallCountForStateHandleByIndex(int index) {
        return STATE_STORAGE.get(index).getNumberOfSuccessfulDiscardCalls();
    }

    public static int getGlobalStorageSize() {
        return STATE_STORAGE.size();
    }

    public static void clearGlobalState() {
        STATE_STORAGE.clear();
    }

    public static int getGlobalDiscardCount() {
        return STATE_STORAGE.stream().mapToInt(LongStateHandle::getNumberOfSuccessfulDiscardCalls).sum();
    }

    public static class LongRetrievableStateHandle
    implements RetrievableStateHandle<LongStateHandle> {
        private static final long serialVersionUID = -3555329254423838912L;
        private final int stateReference;

        public LongRetrievableStateHandle(int stateReference) {
            this.stateReference = stateReference;
        }

        public LongStateHandle retrieveState() {
            return (LongStateHandle)STATE_STORAGE.get(this.stateReference);
        }

        public void discardState() {
            ((LongStateHandle)STATE_STORAGE.get(this.stateReference)).discardState();
        }

        public long getStateSize() {
            return 16L;
        }
    }

    public static class LongStateHandle
    implements StateObject {
        private static final long serialVersionUID = -5752042587113549855L;
        private final Long value;
        private final PreDiscardCallback preDiscardCallback;
        private int numberOfDiscardCalls = 0;
        private int numberOfSuccessfulDiscardCalls = 0;

        public LongStateHandle(long value) {
            this(value, ignored -> {});
        }

        public LongStateHandle(long value, PreDiscardCallback preDiscardCallback) {
            this.value = value;
            this.preDiscardCallback = preDiscardCallback;
        }

        public long getValue() {
            return this.value;
        }

        public void discardState() {
            try {
                this.preDiscardCallback.run(this.numberOfDiscardCalls);
                ++this.numberOfSuccessfulDiscardCalls;
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to discard.", e);
            }
            finally {
                ++this.numberOfDiscardCalls;
            }
        }

        public int getNumberOfDiscardCalls() {
            return this.numberOfDiscardCalls;
        }

        public int getNumberOfSuccessfulDiscardCalls() {
            return this.numberOfSuccessfulDiscardCalls;
        }

        public boolean isDiscarded() {
            return this.numberOfSuccessfulDiscardCalls > 0;
        }

        public long getStateSize() {
            return 8L;
        }

        public String toString() {
            return new StringJoiner(", ", LongStateHandle.class.getSimpleName() + "[", "]").add("value=" + this.value).add("numberOfDiscardCalls=" + this.numberOfDiscardCalls).toString();
        }
    }

    @FunctionalInterface
    public static interface PreDiscardCallback
    extends Serializable {
        public void run(int var1) throws Exception;
    }
}

