/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.memory;

import org.apache.flink.runtime.memory.MemoryReservationException;
import org.apache.flink.runtime.memory.UnsafeMemoryBudget;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class UnsafeMemoryBudgetTest {
    UnsafeMemoryBudgetTest() {
    }

    @Test
    void testGetTotalMemory() {
        UnsafeMemoryBudget budget = UnsafeMemoryBudgetTest.createUnsafeMemoryBudget();
        Assertions.assertThat((long)budget.getTotalMemorySize()).isEqualTo(100L);
    }

    @Test
    void testAvailableMemory() throws MemoryReservationException {
        UnsafeMemoryBudget budget = UnsafeMemoryBudgetTest.createUnsafeMemoryBudget();
        Assertions.assertThat((long)budget.getAvailableMemorySize()).isEqualTo(100L);
        budget.reserveMemory(10L);
        Assertions.assertThat((long)budget.getAvailableMemorySize()).isEqualTo(90L);
        budget.releaseMemory(10L);
        Assertions.assertThat((long)budget.getAvailableMemorySize()).isEqualTo(100L);
    }

    @Test
    void testReserveMemory() throws MemoryReservationException {
        UnsafeMemoryBudget budget = UnsafeMemoryBudgetTest.createUnsafeMemoryBudget();
        budget.reserveMemory(50L);
        Assertions.assertThat((long)budget.getAvailableMemorySize()).isEqualTo(50L);
    }

    @Test
    void testReserveMemoryOverLimitFails() {
        UnsafeMemoryBudget budget = UnsafeMemoryBudgetTest.createUnsafeMemoryBudget();
        Assertions.assertThatExceptionOfType(MemoryReservationException.class).isThrownBy(() -> budget.reserveMemory(120L));
    }

    @Test
    void testReleaseMemory() throws MemoryReservationException {
        UnsafeMemoryBudget budget = UnsafeMemoryBudgetTest.createUnsafeMemoryBudget();
        budget.reserveMemory(50L);
        budget.releaseMemory(30L);
        Assertions.assertThat((long)budget.getAvailableMemorySize()).isEqualTo(80L);
    }

    @Test
    void testReleaseMemoryMoreThanReservedFails() throws MemoryReservationException {
        UnsafeMemoryBudget budget = UnsafeMemoryBudgetTest.createUnsafeMemoryBudget();
        budget.reserveMemory(50L);
        Assertions.assertThatExceptionOfType(IllegalStateException.class).isThrownBy(() -> budget.releaseMemory(70L));
    }

    private static UnsafeMemoryBudget createUnsafeMemoryBudget() {
        return new UnsafeMemoryBudget(100L);
    }
}

