/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.io.IOException;
import java.util.Optional;
import org.apache.flink.runtime.io.network.partition.BufferAvailabilityListener;
import org.apache.flink.runtime.io.network.partition.PartitionRequestListener;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.ResultPartitionProvider;
import org.apache.flink.runtime.io.network.partition.ResultSubpartitionIndexSet;
import org.apache.flink.runtime.io.network.partition.ResultSubpartitionView;

public class TestingResultPartitionProvider
implements ResultPartitionProvider {
    private final CreateSubpartitionView createSubpartitionViewFunction;
    private final CreateSubpartitionViewOrRegisterListener createSubpartitionViewOrRegisterListenerFunction;
    private final ReleasePartitionRequestListener releasePartitionRequestListenerConsumer;

    public TestingResultPartitionProvider(CreateSubpartitionView createSubpartitionViewFunction, CreateSubpartitionViewOrRegisterListener createSubpartitionViewOrRegisterListenerFunction, ReleasePartitionRequestListener releasePartitionRequestListenerConsumer) {
        this.createSubpartitionViewFunction = createSubpartitionViewFunction;
        this.createSubpartitionViewOrRegisterListenerFunction = createSubpartitionViewOrRegisterListenerFunction;
        this.releasePartitionRequestListenerConsumer = releasePartitionRequestListenerConsumer;
    }

    public ResultSubpartitionView createSubpartitionView(ResultPartitionID partitionId, ResultSubpartitionIndexSet indexSet, BufferAvailabilityListener availabilityListener) throws IOException {
        return this.createSubpartitionViewFunction.createSubpartitionView(partitionId, indexSet, availabilityListener);
    }

    public Optional<ResultSubpartitionView> createSubpartitionViewOrRegisterListener(ResultPartitionID partitionId, ResultSubpartitionIndexSet indexSet, BufferAvailabilityListener availabilityListener, PartitionRequestListener notifier) throws IOException {
        return this.createSubpartitionViewOrRegisterListenerFunction.createSubpartitionViewOrRegisterListener(partitionId, indexSet, availabilityListener, notifier);
    }

    public void releasePartitionRequestListener(PartitionRequestListener notifier) {
        this.releasePartitionRequestListenerConsumer.releasePartitionRequestListener(notifier);
    }

    public static TestingResultPartitionProviderBuilder newBuilder() {
        return new TestingResultPartitionProviderBuilder();
    }

    public static interface ReleasePartitionRequestListener {
        public void releasePartitionRequestListener(PartitionRequestListener var1);
    }

    public static interface CreateSubpartitionViewOrRegisterListener {
        public Optional<ResultSubpartitionView> createSubpartitionViewOrRegisterListener(ResultPartitionID var1, ResultSubpartitionIndexSet var2, BufferAvailabilityListener var3, PartitionRequestListener var4) throws IOException;
    }

    public static interface CreateSubpartitionView {
        public ResultSubpartitionView createSubpartitionView(ResultPartitionID var1, ResultSubpartitionIndexSet var2, BufferAvailabilityListener var3) throws IOException;
    }

    public static class TestingResultPartitionProviderBuilder {
        private CreateSubpartitionView createSubpartitionViewFunction = (resultPartitionID, indexSet, availabilityListener) -> null;
        private CreateSubpartitionViewOrRegisterListener createSubpartitionViewOrRegisterListenerFunction = (partitionId, indexSet, availabilityListener, partitionRequestListener) -> Optional.empty();
        private ReleasePartitionRequestListener releasePartitionRequestListenerConsumer = listener -> {};

        public TestingResultPartitionProviderBuilder setCreateSubpartitionViewFunction(CreateSubpartitionView createSubpartitionViewFunction) {
            this.createSubpartitionViewFunction = createSubpartitionViewFunction;
            return this;
        }

        public TestingResultPartitionProviderBuilder setCreateSubpartitionViewOrNotifyFunction(CreateSubpartitionViewOrRegisterListener createSubpartitionViewOrRegisterListenerFunction) {
            this.createSubpartitionViewOrRegisterListenerFunction = createSubpartitionViewOrRegisterListenerFunction;
            return this;
        }

        public TestingResultPartitionProviderBuilder setReleasePartitionRequestListenerConsumer(ReleasePartitionRequestListener releasePartitionRequestListenerConsumer) {
            this.releasePartitionRequestListenerConsumer = releasePartitionRequestListenerConsumer;
            return this;
        }

        public TestingResultPartitionProvider build() {
            return new TestingResultPartitionProvider(this.createSubpartitionViewFunction, this.createSubpartitionViewOrRegisterListenerFunction, this.releasePartitionRequestListenerConsumer);
        }
    }
}

