/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import org.apache.flink.core.execution.SavepointFormatType;
import org.apache.flink.runtime.checkpoint.CheckpointProperties;
import org.apache.flink.runtime.checkpoint.CheckpointRetentionPolicy;
import org.apache.flink.util.InstantiationUtil;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class CheckpointPropertiesTest {
    CheckpointPropertiesTest() {
    }

    @Test
    void testCheckpointProperties() {
        CheckpointProperties props = CheckpointProperties.forCheckpoint((CheckpointRetentionPolicy)CheckpointRetentionPolicy.RETAIN_ON_FAILURE);
        Assertions.assertThat((boolean)props.forceCheckpoint()).isFalse();
        Assertions.assertThat((boolean)props.discardOnSubsumed()).isTrue();
        Assertions.assertThat((boolean)props.discardOnJobFinished()).isTrue();
        Assertions.assertThat((boolean)props.discardOnJobCancelled()).isTrue();
        Assertions.assertThat((boolean)props.discardOnJobFailed()).isFalse();
        Assertions.assertThat((boolean)props.discardOnJobSuspended()).isTrue();
        props = CheckpointProperties.forCheckpoint((CheckpointRetentionPolicy)CheckpointRetentionPolicy.RETAIN_ON_CANCELLATION);
        Assertions.assertThat((boolean)props.forceCheckpoint()).isFalse();
        Assertions.assertThat((boolean)props.discardOnSubsumed()).isTrue();
        Assertions.assertThat((boolean)props.discardOnJobFinished()).isTrue();
        Assertions.assertThat((boolean)props.discardOnJobCancelled()).isFalse();
        Assertions.assertThat((boolean)props.discardOnJobFailed()).isFalse();
        Assertions.assertThat((boolean)props.discardOnJobSuspended()).isFalse();
    }

    @Test
    void testSavepointProperties() {
        CheckpointProperties props = CheckpointProperties.forSavepoint((boolean)true, (SavepointFormatType)SavepointFormatType.CANONICAL);
        Assertions.assertThat((boolean)props.forceCheckpoint()).isTrue();
        Assertions.assertThat((boolean)props.discardOnSubsumed()).isFalse();
        Assertions.assertThat((boolean)props.discardOnJobFinished()).isFalse();
        Assertions.assertThat((boolean)props.discardOnJobCancelled()).isFalse();
        Assertions.assertThat((boolean)props.discardOnJobFailed()).isFalse();
        Assertions.assertThat((boolean)props.discardOnJobSuspended()).isFalse();
    }

    @Test
    void testIsSavepoint() throws Exception {
        CheckpointProperties props = CheckpointProperties.forCheckpoint((CheckpointRetentionPolicy)CheckpointRetentionPolicy.RETAIN_ON_FAILURE);
        Assertions.assertThat((boolean)props.isSavepoint()).isFalse();
        props = CheckpointProperties.forCheckpoint((CheckpointRetentionPolicy)CheckpointRetentionPolicy.RETAIN_ON_CANCELLATION);
        Assertions.assertThat((boolean)props.isSavepoint()).isFalse();
        props = CheckpointProperties.forSavepoint((boolean)true, (SavepointFormatType)SavepointFormatType.CANONICAL);
        Assertions.assertThat((boolean)props.isSavepoint()).isTrue();
        CheckpointProperties deserializedCheckpointProperties = (CheckpointProperties)InstantiationUtil.deserializeObject((byte[])InstantiationUtil.serializeObject((Object)props), (ClassLoader)this.getClass().getClassLoader());
        Assertions.assertThat((boolean)deserializedCheckpointProperties.isSavepoint()).isTrue();
    }
}

