/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages.job;

import io.swagger.v3.oas.annotations.Hidden;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.AccessExecution;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricFetcher;
import org.apache.flink.runtime.rest.handler.util.MutableIOMetrics;
import org.apache.flink.runtime.rest.messages.ResponseBody;
import org.apache.flink.runtime.rest.messages.job.StatusDurationUtils;
import org.apache.flink.runtime.rest.messages.job.metrics.IOMetricsInfo;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.util.Preconditions;

public class SubtaskExecutionAttemptDetailsInfo
implements ResponseBody {
    public static final String FIELD_NAME_SUBTASK_INDEX = "subtask";
    public static final String FIELD_NAME_STATUS = "status";
    public static final String FIELD_NAME_ATTEMPT = "attempt";
    @Deprecated
    public static final String FIELD_NAME_HOST = "host";
    public static final String FIELD_NAME_ENDPOINT = "endpoint";
    public static final String FIELD_NAME_START_TIME = "start-time";
    public static final String FIELD_NAME_COMPATIBLE_START_TIME = "start_time";
    public static final String FIELD_NAME_END_TIME = "end-time";
    public static final String FIELD_NAME_DURATION = "duration";
    public static final String FIELD_NAME_METRICS = "metrics";
    public static final String FIELD_NAME_TASKMANAGER_ID = "taskmanager-id";
    public static final String FIELD_NAME_STATUS_DURATION = "status-duration";
    public static final String FIELD_NAME_OTHER_CONCURRENT_ATTEMPTS = "other-concurrent-attempts";
    @JsonProperty(value="subtask")
    private final int subtaskIndex;
    @JsonProperty(value="status")
    private final ExecutionState status;
    @JsonProperty(value="attempt")
    private final int attempt;
    @JsonProperty(value="host")
    private final String host;
    @JsonProperty(value="endpoint")
    private final String endpoint;
    @JsonProperty(value="start-time")
    private final long startTime;
    @Hidden
    @JsonProperty(value="start_time")
    private final long startTimeCompatible;
    @JsonProperty(value="end-time")
    private final long endTime;
    @JsonProperty(value="duration")
    private final long duration;
    @JsonProperty(value="metrics")
    private final IOMetricsInfo ioMetricsInfo;
    @JsonProperty(value="taskmanager-id")
    private final String taskmanagerId;
    @JsonProperty(value="status-duration")
    private final Map<ExecutionState, Long> statusDuration;
    @JsonProperty(value="other-concurrent-attempts")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @Nullable
    private final List<SubtaskExecutionAttemptDetailsInfo> otherConcurrentAttempts;

    @JsonCreator
    public SubtaskExecutionAttemptDetailsInfo(@JsonProperty(value="subtask") int subtaskIndex, @JsonProperty(value="status") ExecutionState status, @JsonProperty(value="attempt") int attempt, @JsonProperty(value="host") String host, @JsonProperty(value="endpoint") String endpoint, @JsonProperty(value="start-time") long startTime, @JsonProperty(value="end-time") long endTime, @JsonProperty(value="duration") long duration, @JsonProperty(value="metrics") IOMetricsInfo ioMetricsInfo, @JsonProperty(value="taskmanager-id") String taskmanagerId, @JsonProperty(value="status-duration") Map<ExecutionState, Long> statusDuration, @JsonProperty(value="other-concurrent-attempts") @Nullable List<SubtaskExecutionAttemptDetailsInfo> otherConcurrentAttempts) {
        this.subtaskIndex = subtaskIndex;
        this.status = (ExecutionState)((Object)Preconditions.checkNotNull((Object)((Object)status)));
        this.attempt = attempt;
        this.host = (String)Preconditions.checkNotNull((Object)host);
        this.endpoint = (String)Preconditions.checkNotNull((Object)endpoint);
        this.startTime = startTime;
        this.startTimeCompatible = startTime;
        this.endTime = endTime;
        this.duration = duration;
        this.ioMetricsInfo = (IOMetricsInfo)Preconditions.checkNotNull((Object)ioMetricsInfo);
        this.taskmanagerId = (String)Preconditions.checkNotNull((Object)taskmanagerId);
        this.statusDuration = (Map)Preconditions.checkNotNull(statusDuration);
        this.otherConcurrentAttempts = otherConcurrentAttempts;
    }

    public int getSubtaskIndex() {
        return this.subtaskIndex;
    }

    public ExecutionState getStatus() {
        return this.status;
    }

    public int getAttempt() {
        return this.attempt;
    }

    @Deprecated
    public String getHost() {
        return this.host;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getStartTimeCompatible() {
        return this.startTimeCompatible;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public long getDuration() {
        return this.duration;
    }

    public Map<ExecutionState, Long> getStatusDuration() {
        return this.statusDuration;
    }

    public long getStatusDuration(ExecutionState state) {
        return this.statusDuration.get((Object)state);
    }

    public IOMetricsInfo getIoMetricsInfo() {
        return this.ioMetricsInfo;
    }

    public String getTaskmanagerId() {
        return this.taskmanagerId;
    }

    public List<SubtaskExecutionAttemptDetailsInfo> getOtherConcurrentAttempts() {
        return this.otherConcurrentAttempts == null ? new ArrayList() : this.otherConcurrentAttempts;
    }

    public static SubtaskExecutionAttemptDetailsInfo create(AccessExecution execution, @Nullable MetricFetcher metricFetcher, JobID jobID, JobVertexID jobVertexID, @Nullable List<SubtaskExecutionAttemptDetailsInfo> otherConcurrentAttempts) {
        long endTime;
        ExecutionState status = execution.getState();
        long now = System.currentTimeMillis();
        TaskManagerLocation location = execution.getAssignedResourceLocation();
        String host = location == null ? "(unassigned)" : location.getHostname();
        String endpoint = location == null ? "(unassigned)" : location.getEndpoint();
        String taskmanagerId = location == null ? "(unassigned)" : location.getResourceID().toString();
        long startTime = execution.getStateTimestamp(ExecutionState.DEPLOYING);
        if (startTime == 0L) {
            startTime = -1L;
        }
        long l = endTime = status.isTerminal() ? execution.getStateTimestamp(status) : -1L;
        long duration = startTime > 0L ? (endTime > 0L ? endTime : now) - startTime : -1L;
        MutableIOMetrics ioMetrics = new MutableIOMetrics();
        ioMetrics.addIOMetrics(execution, metricFetcher, jobID.toString(), jobVertexID.toString());
        IOMetricsInfo ioMetricsInfo = new IOMetricsInfo(ioMetrics.getNumBytesIn(), ioMetrics.isNumBytesInComplete(), ioMetrics.getNumBytesOut(), ioMetrics.isNumBytesOutComplete(), ioMetrics.getNumRecordsIn(), ioMetrics.isNumRecordsInComplete(), ioMetrics.getNumRecordsOut(), ioMetrics.isNumRecordsOutComplete(), ioMetrics.getAccumulateBackPressuredTime(), ioMetrics.getAccumulateIdleTime(), ioMetrics.getAccumulateBusyTime());
        return new SubtaskExecutionAttemptDetailsInfo(execution.getParallelSubtaskIndex(), status, execution.getAttemptNumber(), host, endpoint, startTime, endTime, duration, ioMetricsInfo, taskmanagerId, StatusDurationUtils.getExecutionStateDuration(execution), otherConcurrentAttempts);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubtaskExecutionAttemptDetailsInfo that = (SubtaskExecutionAttemptDetailsInfo)o;
        return this.subtaskIndex == that.subtaskIndex && this.status == that.status && this.attempt == that.attempt && Objects.equals(this.host, that.host) && Objects.equals(this.endpoint, that.endpoint) && this.startTime == that.startTime && this.startTimeCompatible == that.startTimeCompatible && this.endTime == that.endTime && this.duration == that.duration && Objects.equals(this.ioMetricsInfo, that.ioMetricsInfo) && Objects.equals(this.taskmanagerId, that.taskmanagerId) && Objects.equals(this.statusDuration, that.statusDuration) && Objects.equals(this.otherConcurrentAttempts, that.otherConcurrentAttempts);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.subtaskIndex, this.status, this.attempt, this.host, this.endpoint, this.startTime, this.startTimeCompatible, this.endTime, this.duration, this.ioMetricsInfo, this.taskmanagerId, this.statusDuration, this.otherConcurrentAttempts});
    }
}

