/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.groups;

import java.util.Map;
import java.util.Set;
import org.apache.flink.runtime.metrics.filter.MetricFilter;
import org.apache.flink.util.Preconditions;

public class ReporterScopedSettings {
    private final int reporterIndex;
    private final char delimiter;
    private final Set<String> excludedVariables;
    private final MetricFilter filter;
    private final Map<String, String> additionalVariables;

    public ReporterScopedSettings(int reporterIndex, char delimiter, MetricFilter filter, Set<String> excludedVariables, Map<String, String> additionalVariables) {
        this.excludedVariables = excludedVariables;
        Preconditions.checkArgument((reporterIndex >= 0 ? 1 : 0) != 0);
        this.reporterIndex = reporterIndex;
        this.delimiter = delimiter;
        this.filter = filter;
        this.additionalVariables = additionalVariables;
    }

    public int getReporterIndex() {
        return this.reporterIndex;
    }

    public char getDelimiter() {
        return this.delimiter;
    }

    public MetricFilter getFilter() {
        return this.filter;
    }

    public Set<String> getExcludedVariables() {
        return this.excludedVariables;
    }

    public Map<String, String> getAdditionalVariables() {
        return this.additionalVariables;
    }
}

