/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.sort;

import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.io.disk.RandomAccessInputView;
import org.apache.flink.runtime.io.disk.SimpleCollectingOutputView;
import org.apache.flink.runtime.io.disk.iomanager.ChannelWriterOutputView;
import org.apache.flink.runtime.memory.ListMemorySegmentSource;
import org.apache.flink.runtime.operators.sort.InMemorySorter;
import org.apache.flink.runtime.operators.sort.LargeRecordHandler;
import org.apache.flink.util.MutableObjectIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NormalizedKeySorter<T>
implements InMemorySorter<T> {
    private static final Logger LOG = LoggerFactory.getLogger(NormalizedKeySorter.class);
    private static final int OFFSET_LEN = 8;
    private static final int DEFAULT_MAX_NORMALIZED_KEY_LEN = 16;
    private static final int MAX_NORMALIZED_KEY_LEN_PER_ELEMENT = 8;
    private static final int MIN_REQUIRED_BUFFERS = 3;
    private static final int LARGE_RECORD_THRESHOLD = 0xA00000;
    private static final long LARGE_RECORD_TAG = Long.MIN_VALUE;
    private static final long POINTER_MASK = Long.MAX_VALUE;
    private final byte[] swapBuffer;
    private final TypeSerializer<T> serializer;
    private final TypeComparator<T> comparator;
    private final SimpleCollectingOutputView recordCollector;
    private final RandomAccessInputView recordBuffer;
    private final RandomAccessInputView recordBufferForComparison;
    private MemorySegment currentSortIndexSegment;
    private final ArrayList<MemorySegment> freeMemory;
    private final ArrayList<MemorySegment> sortIndex;
    private final ArrayList<MemorySegment> recordBufferSegments;
    private long currentDataBufferOffset;
    private long sortIndexBytes;
    private int currentSortIndexOffset;
    private int numRecords;
    private final int numKeyBytes;
    private final int indexEntrySize;
    private final int indexEntriesPerSegment;
    private final int lastIndexEntryOffset;
    private final int segmentSize;
    private final int totalNumBuffers;
    private final boolean normalizedKeyFullyDetermines;
    private final boolean useNormKeyUninverted;

    public NormalizedKeySorter(TypeSerializer<T> serializer, TypeComparator<T> comparator, List<MemorySegment> memory) {
        this(serializer, comparator, memory, 16);
    }

    public NormalizedKeySorter(TypeSerializer<T> serializer, TypeComparator<T> comparator, List<MemorySegment> memory, int maxNormalizedKeyBytes) {
        if (serializer == null || comparator == null || memory == null) {
            throw new NullPointerException();
        }
        if (maxNormalizedKeyBytes < 0) {
            throw new IllegalArgumentException("Maximal number of normalized key bytes must not be negative.");
        }
        this.serializer = serializer;
        this.comparator = comparator;
        this.useNormKeyUninverted = !comparator.invertNormalizedKey();
        this.totalNumBuffers = memory.size();
        if (this.totalNumBuffers < 3) {
            throw new IllegalArgumentException("Normalized-Key sorter requires at least 3 memory buffers.");
        }
        this.segmentSize = memory.get(0).size();
        this.freeMemory = new ArrayList<MemorySegment>(memory);
        this.sortIndex = new ArrayList(16);
        this.recordBufferSegments = new ArrayList(16);
        this.recordCollector = new SimpleCollectingOutputView(this.recordBufferSegments, new ListMemorySegmentSource(this.freeMemory), this.segmentSize);
        this.recordBuffer = new RandomAccessInputView(this.recordBufferSegments, this.segmentSize);
        this.recordBufferForComparison = new RandomAccessInputView(this.recordBufferSegments, this.segmentSize);
        if (this.comparator.supportsNormalizedKey()) {
            int numPartialKeys;
            try {
                numPartialKeys = this.comparator.getFlatComparators().length;
            }
            catch (Throwable t) {
                numPartialKeys = 1;
            }
            int maxLen = Math.min(maxNormalizedKeyBytes, 8 * numPartialKeys);
            this.numKeyBytes = Math.min(this.comparator.getNormalizeKeyLen(), maxLen);
            this.normalizedKeyFullyDetermines = !this.comparator.isNormalizedKeyPrefixOnly(this.numKeyBytes);
        } else {
            this.numKeyBytes = 0;
            this.normalizedKeyFullyDetermines = false;
        }
        this.indexEntrySize = this.numKeyBytes + 8;
        this.indexEntriesPerSegment = this.segmentSize / this.indexEntrySize;
        this.lastIndexEntryOffset = (this.indexEntriesPerSegment - 1) * this.indexEntrySize;
        this.swapBuffer = new byte[this.indexEntrySize];
        this.currentSortIndexSegment = this.nextMemorySegment();
        this.sortIndex.add(this.currentSortIndexSegment);
    }

    @Override
    public int recordSize() {
        return this.indexEntrySize;
    }

    @Override
    public int recordsPerSegment() {
        return this.indexEntriesPerSegment;
    }

    @Override
    public void reset() {
        this.numRecords = 0;
        this.currentSortIndexOffset = 0;
        this.currentDataBufferOffset = 0L;
        this.sortIndexBytes = 0L;
        this.freeMemory.addAll(this.sortIndex);
        this.freeMemory.addAll(this.recordBufferSegments);
        this.sortIndex.clear();
        this.recordBufferSegments.clear();
        this.currentSortIndexSegment = this.nextMemorySegment();
        this.sortIndex.add(this.currentSortIndexSegment);
        this.recordCollector.reset();
    }

    @Override
    public boolean isEmpty() {
        return this.numRecords == 0;
    }

    @Override
    public void dispose() {
        this.freeMemory.clear();
        this.recordBufferSegments.clear();
        this.sortIndex.clear();
    }

    @Override
    public long getCapacity() {
        return (long)this.totalNumBuffers * (long)this.segmentSize;
    }

    @Override
    public long getOccupancy() {
        return this.currentDataBufferOffset + this.sortIndexBytes;
    }

    @Override
    public T getRecord(int logicalPosition) throws IOException {
        return this.getRecordFromBuffer(this.readPointer(logicalPosition));
    }

    @Override
    public T getRecord(T reuse, int logicalPosition) throws IOException {
        return this.getRecordFromBuffer(reuse, this.readPointer(logicalPosition));
    }

    @Override
    public boolean write(T record) throws IOException {
        boolean shortRecord;
        if (this.currentSortIndexOffset > this.lastIndexEntryOffset) {
            if (this.memoryAvailable()) {
                this.currentSortIndexSegment = this.nextMemorySegment();
                this.sortIndex.add(this.currentSortIndexSegment);
                this.currentSortIndexOffset = 0;
                this.sortIndexBytes += (long)this.segmentSize;
            } else {
                return false;
            }
        }
        try {
            this.serializer.serialize(record, (DataOutputView)this.recordCollector);
        }
        catch (EOFException e) {
            return false;
        }
        long newOffset = this.recordCollector.getCurrentOffset();
        boolean bl = shortRecord = newOffset - this.currentDataBufferOffset < 0xA00000L;
        if (!shortRecord && LOG.isDebugEnabled()) {
            LOG.debug("Put a large record ( >10485760 into the sort buffer");
        }
        this.currentSortIndexSegment.putLong(this.currentSortIndexOffset, shortRecord ? this.currentDataBufferOffset : this.currentDataBufferOffset | Long.MIN_VALUE);
        if (this.numKeyBytes != 0) {
            this.comparator.putNormalizedKey(record, this.currentSortIndexSegment, this.currentSortIndexOffset + 8, this.numKeyBytes);
        }
        this.currentSortIndexOffset += this.indexEntrySize;
        this.currentDataBufferOffset = newOffset;
        ++this.numRecords;
        return true;
    }

    private long readPointer(int logicalPosition) {
        if (logicalPosition < 0 || logicalPosition >= this.numRecords) {
            throw new IndexOutOfBoundsException();
        }
        int bufferNum = logicalPosition / this.indexEntriesPerSegment;
        int segmentOffset = logicalPosition % this.indexEntriesPerSegment;
        return this.sortIndex.get(bufferNum).getLong(segmentOffset * this.indexEntrySize) & Long.MAX_VALUE;
    }

    private T getRecordFromBuffer(T reuse, long pointer) throws IOException {
        this.recordBuffer.setReadPosition(pointer);
        return (T)this.serializer.deserialize(reuse, (DataInputView)this.recordBuffer);
    }

    private T getRecordFromBuffer(long pointer) throws IOException {
        this.recordBuffer.setReadPosition(pointer);
        return (T)this.serializer.deserialize((DataInputView)this.recordBuffer);
    }

    private int compareRecords(long pointer1, long pointer2) {
        this.recordBuffer.setReadPosition(pointer1);
        this.recordBufferForComparison.setReadPosition(pointer2);
        try {
            return this.comparator.compareSerialized((DataInputView)this.recordBuffer, (DataInputView)this.recordBufferForComparison);
        }
        catch (IOException ioex) {
            throw new RuntimeException("Error comparing two records.", ioex);
        }
    }

    private boolean memoryAvailable() {
        return !this.freeMemory.isEmpty();
    }

    private MemorySegment nextMemorySegment() {
        return this.freeMemory.remove(this.freeMemory.size() - 1);
    }

    @Override
    public int compare(int i, int j) {
        int segmentNumberI = i / this.indexEntriesPerSegment;
        int segmentOffsetI = i % this.indexEntriesPerSegment * this.indexEntrySize;
        int segmentNumberJ = j / this.indexEntriesPerSegment;
        int segmentOffsetJ = j % this.indexEntriesPerSegment * this.indexEntrySize;
        return this.compare(segmentNumberI, segmentOffsetI, segmentNumberJ, segmentOffsetJ);
    }

    @Override
    public int compare(int segmentNumberI, int segmentOffsetI, int segmentNumberJ, int segmentOffsetJ) {
        MemorySegment segJ;
        MemorySegment segI = this.sortIndex.get(segmentNumberI);
        int val = segI.compare(segJ = this.sortIndex.get(segmentNumberJ), segmentOffsetI + 8, segmentOffsetJ + 8, this.numKeyBytes);
        if (val != 0 || this.normalizedKeyFullyDetermines) {
            return this.useNormKeyUninverted ? val : -val;
        }
        long pointerI = segI.getLong(segmentOffsetI) & Long.MAX_VALUE;
        long pointerJ = segJ.getLong(segmentOffsetJ) & Long.MAX_VALUE;
        return this.compareRecords(pointerI, pointerJ);
    }

    @Override
    public void swap(int i, int j) {
        int segmentNumberI = i / this.indexEntriesPerSegment;
        int segmentOffsetI = i % this.indexEntriesPerSegment * this.indexEntrySize;
        int segmentNumberJ = j / this.indexEntriesPerSegment;
        int segmentOffsetJ = j % this.indexEntriesPerSegment * this.indexEntrySize;
        this.swap(segmentNumberI, segmentOffsetI, segmentNumberJ, segmentOffsetJ);
    }

    @Override
    public void swap(int segmentNumberI, int segmentOffsetI, int segmentNumberJ, int segmentOffsetJ) {
        MemorySegment segI = this.sortIndex.get(segmentNumberI);
        MemorySegment segJ = this.sortIndex.get(segmentNumberJ);
        segI.swapBytes(this.swapBuffer, segJ, segmentOffsetI, segmentOffsetJ, this.indexEntrySize);
    }

    @Override
    public int size() {
        return this.numRecords;
    }

    @Override
    public final MutableObjectIterator<T> getIterator() {
        return new MutableObjectIterator<T>(){
            private final int size;
            private int current;
            private int currentSegment;
            private int currentOffset;
            private MemorySegment currentIndexSegment;
            {
                this.size = NormalizedKeySorter.this.size();
                this.current = 0;
                this.currentSegment = 0;
                this.currentOffset = 0;
                this.currentIndexSegment = (MemorySegment)NormalizedKeySorter.this.sortIndex.get(0);
            }

            public T next(T target) {
                if (this.current < this.size) {
                    ++this.current;
                    if (this.currentOffset > NormalizedKeySorter.this.lastIndexEntryOffset) {
                        this.currentOffset = 0;
                        this.currentIndexSegment = (MemorySegment)NormalizedKeySorter.this.sortIndex.get(++this.currentSegment);
                    }
                    long pointer = this.currentIndexSegment.getLong(this.currentOffset) & Long.MAX_VALUE;
                    this.currentOffset += NormalizedKeySorter.this.indexEntrySize;
                    try {
                        return NormalizedKeySorter.this.getRecordFromBuffer(target, pointer);
                    }
                    catch (IOException ioe) {
                        throw new RuntimeException(ioe);
                    }
                }
                return null;
            }

            public T next() {
                if (this.current < this.size) {
                    ++this.current;
                    if (this.currentOffset > NormalizedKeySorter.this.lastIndexEntryOffset) {
                        this.currentOffset = 0;
                        this.currentIndexSegment = (MemorySegment)NormalizedKeySorter.this.sortIndex.get(++this.currentSegment);
                    }
                    long pointer = this.currentIndexSegment.getLong(this.currentOffset);
                    this.currentOffset += NormalizedKeySorter.this.indexEntrySize;
                    try {
                        return NormalizedKeySorter.this.getRecordFromBuffer(pointer);
                    }
                    catch (IOException ioe) {
                        throw new RuntimeException(ioe);
                    }
                }
                return null;
            }
        };
    }

    @Override
    public void writeToOutput(ChannelWriterOutputView output) throws IOException {
        this.writeToOutput(output, null);
    }

    @Override
    public void writeToOutput(ChannelWriterOutputView output, LargeRecordHandler<T> largeRecordsOutput) throws IOException {
        if (LOG.isDebugEnabled()) {
            if (largeRecordsOutput == null) {
                LOG.debug("Spilling sort buffer without large record handling.");
            } else {
                LOG.debug("Spilling sort buffer with large record handling.");
            }
        }
        int numRecords = this.numRecords;
        int currentMemSeg = 0;
        int currentRecord = 0;
        while (currentRecord < numRecords) {
            MemorySegment currentIndexSegment = this.sortIndex.get(currentMemSeg++);
            for (int offset = 0; currentRecord < numRecords && offset <= this.lastIndexEntryOffset; ++currentRecord, offset += this.indexEntrySize) {
                long pointer = currentIndexSegment.getLong(offset);
                if (pointer >= 0L || largeRecordsOutput == null) {
                    this.recordBuffer.setReadPosition(pointer);
                    this.serializer.copy((DataInputView)this.recordBuffer, (DataOutputView)output);
                    continue;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Spilling large record to large record fetch file.");
                }
                this.recordBuffer.setReadPosition(pointer & Long.MAX_VALUE);
                Object record = this.serializer.deserialize((DataInputView)this.recordBuffer);
                largeRecordsOutput.addRecord(record);
            }
        }
    }

    @Override
    public void writeToOutput(ChannelWriterOutputView output, int start, int num) throws IOException {
        int currentMemSeg = start / this.indexEntriesPerSegment;
        int offset = start % this.indexEntriesPerSegment * this.indexEntrySize;
        while (num > 0) {
            long pointer;
            MemorySegment currentIndexSegment = this.sortIndex.get(currentMemSeg++);
            if (num >= this.indexEntriesPerSegment && offset == 0) {
                while (offset <= this.lastIndexEntryOffset) {
                    pointer = currentIndexSegment.getLong(offset) & Long.MAX_VALUE;
                    this.recordBuffer.setReadPosition(pointer);
                    this.serializer.copy((DataInputView)this.recordBuffer, (DataOutputView)output);
                    offset += this.indexEntrySize;
                }
                num -= this.indexEntriesPerSegment;
            } else {
                while (num > 0 && offset <= this.lastIndexEntryOffset) {
                    pointer = currentIndexSegment.getLong(offset) & Long.MAX_VALUE;
                    this.recordBuffer.setReadPosition(pointer);
                    this.serializer.copy((DataInputView)this.recordBuffer, (DataOutputView)output);
                    --num;
                    offset += this.indexEntrySize;
                }
            }
            offset = 0;
        }
    }
}

