/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.deployment.ResultPartitionDeploymentDescriptor;
import org.apache.flink.runtime.io.network.partition.PartitionTracker;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.resourcemanager.ResourceManagerGateway;
import org.apache.flink.runtime.shuffle.ShuffleDescriptor;

public interface JobMasterPartitionTracker
extends PartitionTracker<ResourceID, ResultPartitionDeploymentDescriptor> {
    public void startTrackingPartition(ResourceID var1, ResultPartitionDeploymentDescriptor var2);

    default public void stopTrackingAndReleasePartitions(Collection<ResultPartitionID> resultPartitionIds) {
        this.stopTrackingAndReleasePartitions(resultPartitionIds, true);
    }

    public void stopTrackingAndReleasePartitions(Collection<ResultPartitionID> var1, boolean var2);

    public CompletableFuture<Void> stopTrackingAndPromotePartitions(Collection<ResultPartitionID> var1);

    public Collection<ResultPartitionDeploymentDescriptor> getAllTrackedPartitions();

    default public Collection<ResultPartitionDeploymentDescriptor> getAllTrackedNonClusterPartitions() {
        return this.getAllTrackedPartitions().stream().filter(descriptor -> !descriptor.getPartitionType().isPersistent()).collect(Collectors.toList());
    }

    default public Collection<ResultPartitionDeploymentDescriptor> getAllTrackedClusterPartitions() {
        return this.getAllTrackedPartitions().stream().filter(descriptor -> descriptor.getPartitionType().isPersistent()).collect(Collectors.toList());
    }

    public void connectToResourceManager(ResourceManagerGateway var1);

    public List<ShuffleDescriptor> getClusterPartitionShuffleDescriptors(IntermediateDataSetID var1);
}

