/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.throughput;

import org.apache.flink.runtime.throughput.BufferSizeEMA;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class BufferSizeEMATest {
    BufferSizeEMATest() {
    }

    @Test
    void testCalculationBufferSize() {
        BufferSizeEMA calculator = new BufferSizeEMA(200, 10, 3L);
        Assertions.assertThat((int)calculator.calculateBufferSize(111L, 13)).isEqualTo(104);
        Assertions.assertThat((int)calculator.calculateBufferSize(107L, 7)).isEqualTo(59);
        Assertions.assertThat((int)calculator.calculateBufferSize(107L, 7)).isEqualTo(37);
        Assertions.assertThat((int)calculator.calculateBufferSize(107L, 7)).isEqualTo(26);
        Assertions.assertThat((int)calculator.calculateBufferSize(107L, 7)).isEqualTo(20);
        Assertions.assertThat((int)calculator.calculateBufferSize(107L, 7)).isEqualTo(17);
        Assertions.assertThat((int)calculator.calculateBufferSize(107L, 13)).isEqualTo(12);
        Assertions.assertThat((int)calculator.calculateBufferSize(107L, 13)).isEqualTo(10);
        Assertions.assertThat((int)calculator.calculateBufferSize(333L, 1)).isEqualTo(15);
        Assertions.assertThat((int)calculator.calculateBufferSize(333L, 1)).isEqualTo(22);
        Assertions.assertThat((int)calculator.calculateBufferSize(333L, 1)).isEqualTo(33);
        Assertions.assertThat((int)calculator.calculateBufferSize(333L, 1)).isEqualTo(49);
        Assertions.assertThat((int)calculator.calculateBufferSize(333L, 1)).isEqualTo(73);
        Assertions.assertThat((int)calculator.calculateBufferSize(333L, 1)).isEqualTo(109);
    }

    @Test
    void testSizeGreaterThanMaxSize() {
        BufferSizeEMA calculator = new BufferSizeEMA(200, 10, 3L);
        Assertions.assertThat((int)calculator.calculateBufferSize(0L, 1)).isEqualTo(100);
        Assertions.assertThat((int)calculator.calculateBufferSize(1000L, 1)).isEqualTo(150);
        Assertions.assertThat((int)calculator.calculateBufferSize(1000L, 1)).isEqualTo(200);
        Assertions.assertThat((int)calculator.calculateBufferSize(1000L, 1)).isEqualTo(200);
    }

    @Test
    void testSizeLessThanMinSize() {
        BufferSizeEMA calculator = new BufferSizeEMA(200, 10, 3L);
        Assertions.assertThat((int)calculator.calculateBufferSize(0L, 1)).isEqualTo(100);
        Assertions.assertThat((int)calculator.calculateBufferSize(0L, 1)).isEqualTo(50);
        Assertions.assertThat((int)calculator.calculateBufferSize(0L, 1)).isEqualTo(25);
        Assertions.assertThat((int)calculator.calculateBufferSize(0L, 1)).isEqualTo(12);
        Assertions.assertThat((int)calculator.calculateBufferSize(0L, 1)).isEqualTo(10);
        Assertions.assertThat((int)calculator.calculateBufferSize(0L, 1)).isEqualTo(10);
    }

    @Test
    void testNegativeTotalSize() {
        BufferSizeEMA calculator = new BufferSizeEMA(100, 200, 2L);
        Assertions.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> calculator.calculateBufferSize(-1L, 1));
    }

    @Test
    void testZeroBuffers() {
        BufferSizeEMA calculator = new BufferSizeEMA(100, 200, 2L);
        Assertions.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> calculator.calculateBufferSize(1L, 0));
    }
}

