/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.testutils;

import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.clusterframework.ApplicationStatus;
import org.apache.flink.runtime.highavailability.JobResultEntry;
import org.apache.flink.runtime.highavailability.JobResultStore;
import org.apache.flink.runtime.jobmaster.JobResult;
import org.apache.flink.util.concurrent.FutureUtils;
import org.apache.flink.util.function.SupplierWithException;

public class TestingJobResultStore
implements JobResultStore {
    public static final JobResult DUMMY_JOB_RESULT = TestingJobResultStore.createSuccessfulJobResult(new JobID());
    private final Function<JobResultEntry, CompletableFuture<Void>> createDirtyResultConsumer;
    private final Function<JobID, CompletableFuture<Void>> markResultAsCleanConsumer;
    private final Function<JobID, CompletableFuture<Boolean>> hasJobResultEntryFunction;
    private final Function<JobID, CompletableFuture<Boolean>> hasDirtyJobResultEntryFunction;
    private final Function<JobID, CompletableFuture<Boolean>> hasCleanJobResultEntryFunction;
    private final SupplierWithException<Set<JobResult>, ? extends IOException> getDirtyResultsSupplier;

    public static JobResult createSuccessfulJobResult(JobID jobId) {
        return TestingJobResultStore.createJobResult(jobId, ApplicationStatus.SUCCEEDED);
    }

    public static JobResult createJobResult(JobID jobId, ApplicationStatus applicationStatus) {
        return new JobResult.Builder().jobId(jobId).applicationStatus(applicationStatus).netRuntime(1L).build();
    }

    private TestingJobResultStore(Function<JobResultEntry, CompletableFuture<Void>> createDirtyResultConsumer, Function<JobID, CompletableFuture<Void>> markResultAsCleanConsumer, Function<JobID, CompletableFuture<Boolean>> hasJobResultEntryFunction, Function<JobID, CompletableFuture<Boolean>> hasDirtyJobResultEntryFunction, Function<JobID, CompletableFuture<Boolean>> hasCleanJobResultEntryFunction, SupplierWithException<Set<JobResult>, ? extends IOException> getDirtyResultsSupplier) {
        this.createDirtyResultConsumer = createDirtyResultConsumer;
        this.markResultAsCleanConsumer = markResultAsCleanConsumer;
        this.hasJobResultEntryFunction = hasJobResultEntryFunction;
        this.hasDirtyJobResultEntryFunction = hasDirtyJobResultEntryFunction;
        this.hasCleanJobResultEntryFunction = hasCleanJobResultEntryFunction;
        this.getDirtyResultsSupplier = getDirtyResultsSupplier;
    }

    public CompletableFuture<Void> createDirtyResultAsync(JobResultEntry jobResultEntry) {
        return this.createDirtyResultConsumer.apply(jobResultEntry);
    }

    public CompletableFuture<Void> markResultAsCleanAsync(JobID jobId) {
        return this.markResultAsCleanConsumer.apply(jobId);
    }

    public CompletableFuture<Boolean> hasJobResultEntryAsync(JobID jobId) {
        return this.hasJobResultEntryFunction.apply(jobId);
    }

    public CompletableFuture<Boolean> hasDirtyJobResultEntryAsync(JobID jobId) {
        return this.hasDirtyJobResultEntryFunction.apply(jobId);
    }

    public CompletableFuture<Boolean> hasCleanJobResultEntryAsync(JobID jobId) {
        return this.hasCleanJobResultEntryFunction.apply(jobId);
    }

    public Set<JobResult> getDirtyResults() throws IOException {
        return (Set)this.getDirtyResultsSupplier.get();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Function<JobResultEntry, CompletableFuture<Void>> createDirtyResultConsumer = jobResultEntry -> FutureUtils.completedVoidFuture();
        private Function<JobID, CompletableFuture<Void>> markResultAsCleanConsumer = jobID -> FutureUtils.completedVoidFuture();
        private Function<JobID, CompletableFuture<Boolean>> hasJobResultEntryFunction = jobID -> CompletableFuture.completedFuture(false);
        private Function<JobID, CompletableFuture<Boolean>> hasDirtyJobResultEntryFunction = jobID -> CompletableFuture.completedFuture(false);
        private Function<JobID, CompletableFuture<Boolean>> hasCleanJobResultEntryFunction = jobID -> CompletableFuture.completedFuture(false);
        private SupplierWithException<Set<JobResult>, ? extends IOException> getDirtyResultsSupplier = Collections::emptySet;

        public Builder withCreateDirtyResultConsumer(Function<JobResultEntry, CompletableFuture<Void>> createDirtyResultConsumer) {
            this.createDirtyResultConsumer = createDirtyResultConsumer;
            return this;
        }

        public Builder withMarkResultAsCleanConsumer(Function<JobID, CompletableFuture<Void>> markResultAsCleanConsumer) {
            this.markResultAsCleanConsumer = markResultAsCleanConsumer;
            return this;
        }

        public Builder withHasJobResultEntryFunction(Function<JobID, CompletableFuture<Boolean>> hasJobResultEntryFunction) {
            this.hasJobResultEntryFunction = hasJobResultEntryFunction;
            return this;
        }

        public Builder withHasDirtyJobResultEntryFunction(Function<JobID, CompletableFuture<Boolean>> hasDirtyJobResultEntryFunction) {
            this.hasDirtyJobResultEntryFunction = hasDirtyJobResultEntryFunction;
            return this;
        }

        public Builder withHasCleanJobResultEntryFunction(Function<JobID, CompletableFuture<Boolean>> hasCleanJobResultEntryFunction) {
            this.hasCleanJobResultEntryFunction = hasCleanJobResultEntryFunction;
            return this;
        }

        public Builder withGetDirtyResultsSupplier(SupplierWithException<Set<JobResult>, ? extends IOException> getDirtyResultsSupplier) {
            this.getDirtyResultsSupplier = getDirtyResultsSupplier;
            return this;
        }

        public TestingJobResultStore build() {
            return new TestingJobResultStore(this.createDirtyResultConsumer, this.markResultAsCleanConsumer, this.hasJobResultEntryFunction, this.hasDirtyJobResultEntryFunction, this.hasCleanJobResultEntryFunction, this.getDirtyResultsSupplier);
        }
    }
}

