/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler;

import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionGraph;
import org.apache.flink.runtime.executiongraph.ErrorInfo;
import org.apache.flink.runtime.scheduler.ExecutionGraphInfo;
import org.apache.flink.runtime.scheduler.exceptionhistory.RootExceptionHistoryEntry;
import org.apache.flink.shaded.guava31.com.google.common.collect.Iterables;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class ExecutionGraphInfoTest {
    @Test
    public void testExecutionGraphHistoryBeingDerivedFromFailedExecutionGraph() {
        ArchivedExecutionGraph executionGraph = ArchivedExecutionGraph.createSparseArchivedExecutionGraph((JobID)new JobID(), (String)"test job name", (JobStatus)JobStatus.FAILED, (Throwable)new RuntimeException("Expected RuntimeException"), null, (long)System.currentTimeMillis());
        ExecutionGraphInfo executionGraphInfo = new ExecutionGraphInfo(executionGraph);
        ErrorInfo failureInfo = executionGraphInfo.getArchivedExecutionGraph().getFailureInfo();
        RootExceptionHistoryEntry actualEntry = (RootExceptionHistoryEntry)Iterables.getOnlyElement((Iterable)executionGraphInfo.getExceptionHistory());
        Assertions.assertThat((Object)failureInfo).isNotNull();
        Assertions.assertThat((Throwable)failureInfo.getException()).isEqualTo((Object)actualEntry.getException());
        Assertions.assertThat((long)failureInfo.getTimestamp()).isEqualTo(actualEntry.getTimestamp());
        Assertions.assertThat((boolean)actualEntry.isGlobal()).isTrue();
        Assertions.assertThat((String)actualEntry.getFailingTaskName()).isNull();
        Assertions.assertThat((Object)actualEntry.getTaskManagerLocation()).isNull();
    }
}

