/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.leaderelection;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.annotation.Nullable;
import org.apache.flink.runtime.leaderelection.LeaderInformation;
import org.apache.flink.runtime.testutils.CommonTestUtils;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.function.SupplierWithException;

public class TestingLeaderBase {
    protected final BlockingQueue<LeaderInformation> leaderEventQueue = new LinkedBlockingQueue<LeaderInformation>();
    private final BlockingQueue<Throwable> errorQueue = new LinkedBlockingQueue<Throwable>();
    private boolean isLeader = false;
    private Throwable error;

    public void waitForLeader() throws Exception {
        this.throwExceptionIfNotNull();
        CommonTestUtils.waitUntilCondition((SupplierWithException<Boolean, Exception>)((SupplierWithException)() -> {
            LeaderInformation leader = this.leaderEventQueue.take();
            return !leader.isEmpty();
        }));
        this.isLeader = true;
    }

    public void waitForRevokeLeader() throws Exception {
        this.throwExceptionIfNotNull();
        CommonTestUtils.waitUntilCondition((SupplierWithException<Boolean, Exception>)((SupplierWithException)() -> {
            LeaderInformation leader = this.leaderEventQueue.take();
            return leader.isEmpty();
        }));
        this.isLeader = false;
    }

    public void waitForError() throws Exception {
        this.error = this.errorQueue.take();
    }

    public void clearError() {
        this.error = null;
    }

    public void handleError(Throwable ex) {
        this.errorQueue.offer(ex);
    }

    @Nullable
    public Throwable getError() {
        return this.error == null ? (Throwable)this.errorQueue.poll() : this.error;
    }

    public void throwErrorIfPresent() {
        String assertionErrorMessage = "An unhandled error was caught during test execution.";
        if (this.error != null) {
            throw new AssertionError("An unhandled error was caught during test execution.", this.error);
        }
        if (!this.errorQueue.isEmpty()) {
            throw new AssertionError("An unhandled error was caught during test execution.", (Throwable)this.errorQueue.poll());
        }
    }

    public boolean isLeader() {
        return this.isLeader;
    }

    private void throwExceptionIfNotNull() throws Exception {
        if (this.error != null) {
            ExceptionUtils.rethrowException((Throwable)this.error);
        }
    }
}

