/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.jobmanager.scheduler.Locality;
import org.apache.flink.runtime.jobmanager.slots.TaskManagerGateway;
import org.apache.flink.runtime.jobmaster.LogicalSlot;
import org.apache.flink.runtime.jobmaster.SlotOwner;
import org.apache.flink.runtime.jobmaster.SlotRequestId;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.util.Preconditions;

public class TestingLogicalSlot
implements LogicalSlot {
    private final TaskManagerLocation taskManagerLocation;
    private final TaskManagerGateway taskManagerGateway;
    private final AtomicReference<LogicalSlot.Payload> payloadReference;
    private final CompletableFuture<?> releaseFuture;
    private final boolean automaticallyCompleteReleaseFuture;
    private final SlotOwner slotOwner;
    private final AllocationID allocationId;
    private final SlotRequestId slotRequestId;
    private boolean released;

    TestingLogicalSlot(TaskManagerLocation taskManagerLocation, TaskManagerGateway taskManagerGateway, AllocationID allocationId, SlotRequestId slotRequestId, boolean automaticallyCompleteReleaseFuture, SlotOwner slotOwner) {
        this.taskManagerLocation = (TaskManagerLocation)Preconditions.checkNotNull((Object)taskManagerLocation);
        this.taskManagerGateway = (TaskManagerGateway)Preconditions.checkNotNull((Object)taskManagerGateway);
        this.payloadReference = new AtomicReference();
        this.allocationId = (AllocationID)Preconditions.checkNotNull((Object)allocationId);
        this.slotRequestId = (SlotRequestId)Preconditions.checkNotNull((Object)slotRequestId);
        this.releaseFuture = new CompletableFuture();
        this.automaticallyCompleteReleaseFuture = automaticallyCompleteReleaseFuture;
        this.slotOwner = (SlotOwner)Preconditions.checkNotNull((Object)slotOwner);
    }

    public TaskManagerLocation getTaskManagerLocation() {
        return this.taskManagerLocation;
    }

    public TaskManagerGateway getTaskManagerGateway() {
        return this.taskManagerGateway;
    }

    public Locality getLocality() {
        return Locality.UNKNOWN;
    }

    public boolean isAlive() {
        return !this.releaseFuture.isDone();
    }

    public boolean tryAssignPayload(LogicalSlot.Payload payload) {
        return this.payloadReference.compareAndSet(null, payload);
    }

    @Nullable
    public LogicalSlot.Payload getPayload() {
        return this.payloadReference.get();
    }

    public CompletableFuture<?> releaseSlot(@Nullable Throwable cause) {
        if (!this.released) {
            this.released = true;
            this.tryAssignPayload(TERMINATED_PAYLOAD);
            this.payloadReference.get().fail(cause);
            this.slotOwner.returnLogicalSlot((LogicalSlot)this);
            if (this.automaticallyCompleteReleaseFuture) {
                this.releaseFuture.complete(null);
            }
        }
        return this.releaseFuture;
    }

    public AllocationID getAllocationId() {
        return this.allocationId;
    }

    public SlotRequestId getSlotRequestId() {
        return this.slotRequestId;
    }

    public CompletableFuture<?> getReleaseFuture() {
        return this.releaseFuture;
    }
}

