/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.runtime.io.network.partition.hybrid.BufferIndexAndChannel;
import org.apache.flink.runtime.io.network.partition.hybrid.HsSpillingInfoProvider;

public interface HsSpillingStrategy {
    public Optional<Decision> onMemoryUsageChanged(int var1, int var2);

    public Optional<Decision> onBufferFinished(int var1, int var2);

    public Optional<Decision> onBufferConsumed(BufferIndexAndChannel var1);

    public Decision decideActionWithGlobalInfo(HsSpillingInfoProvider var1);

    public Decision onResultPartitionClosed(HsSpillingInfoProvider var1);

    public static class Decision {
        private final Map<Integer, List<BufferIndexAndChannel>> bufferToSpill;
        private final Map<Integer, List<BufferIndexAndChannel>> bufferToRelease;
        public static final Decision NO_ACTION = new Decision(Collections.emptyMap(), Collections.emptyMap());

        private Decision(Map<Integer, List<BufferIndexAndChannel>> bufferToSpill, Map<Integer, List<BufferIndexAndChannel>> bufferToRelease) {
            this.bufferToSpill = bufferToSpill;
            this.bufferToRelease = bufferToRelease;
        }

        public Map<Integer, List<BufferIndexAndChannel>> getBufferToSpill() {
            return this.bufferToSpill;
        }

        public Map<Integer, List<BufferIndexAndChannel>> getBufferToRelease() {
            return this.bufferToRelease;
        }

        public static Builder builder() {
            return new Builder();
        }

        static class Builder {
            private final Map<Integer, List<BufferIndexAndChannel>> bufferToSpill = new HashMap<Integer, List<BufferIndexAndChannel>>();
            private final Map<Integer, List<BufferIndexAndChannel>> bufferToRelease = new HashMap<Integer, List<BufferIndexAndChannel>>();

            private Builder() {
            }

            public Builder addBufferToSpill(BufferIndexAndChannel buffer) {
                this.bufferToSpill.computeIfAbsent(buffer.getChannel(), k -> new ArrayList()).add(buffer);
                return this;
            }

            public Builder addBufferToSpill(int subpartitionId, List<BufferIndexAndChannel> buffers) {
                this.bufferToSpill.computeIfAbsent(subpartitionId, k -> new ArrayList()).addAll(buffers);
                return this;
            }

            public Builder addBufferToSpill(int subpartitionId, Deque<BufferIndexAndChannel> buffers) {
                this.bufferToSpill.computeIfAbsent(subpartitionId, k -> new ArrayList()).addAll(buffers);
                return this;
            }

            public Builder addBufferToRelease(BufferIndexAndChannel buffer) {
                this.bufferToRelease.computeIfAbsent(buffer.getChannel(), k -> new ArrayList()).add(buffer);
                return this;
            }

            public Builder addBufferToRelease(int subpartitionId, List<BufferIndexAndChannel> buffers) {
                this.bufferToRelease.computeIfAbsent(subpartitionId, k -> new ArrayList()).addAll(buffers);
                return this;
            }

            public Builder addBufferToRelease(int subpartitionId, Deque<BufferIndexAndChannel> buffers) {
                this.bufferToRelease.computeIfAbsent(subpartitionId, k -> new ArrayList()).addAll(buffers);
                return this;
            }

            public Decision build() {
                return new Decision(this.bufferToSpill, this.bufferToRelease);
            }
        }
    }
}

