/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor.partition;

import java.util.Collection;
import java.util.Collections;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.taskexecutor.partition.PartitionTable;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class PartitionTableTest {
    private static final JobID JOB_ID = new JobID();
    private static final ResultPartitionID PARTITION_ID = new ResultPartitionID();

    PartitionTableTest() {
    }

    @Test
    void testEmptyTable() {
        PartitionTable table = new PartitionTable();
        Collection partitionsForNonExistingJob = table.stopTrackingPartitions((Object)JOB_ID);
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)partitionsForNonExistingJob).isNotNull()).isEmpty();
        Assertions.assertThat((boolean)table.hasTrackedPartitions((Object)JOB_ID)).isFalse();
    }

    @Test
    void testStartTrackingPartition() {
        PartitionTable table = new PartitionTable();
        table.startTrackingPartitions((Object)JOB_ID, Collections.singletonList(PARTITION_ID));
        Assertions.assertThat((boolean)table.hasTrackedPartitions((Object)JOB_ID)).isTrue();
    }

    @Test
    void testStartTrackingZeroPartitionDoesNotMutateState() {
        PartitionTable table = new PartitionTable();
        table.startTrackingPartitions((Object)JOB_ID, Collections.emptyList());
        Assertions.assertThat((boolean)table.hasTrackedPartitions((Object)JOB_ID)).isFalse();
    }

    @Test
    void testStopTrackingAllPartitions() {
        PartitionTable table = new PartitionTable();
        table.startTrackingPartitions((Object)JOB_ID, Collections.singletonList(PARTITION_ID));
        Collection storedPartitions = table.stopTrackingPartitions((Object)JOB_ID);
        Assertions.assertThat((Collection)storedPartitions).contains((Object[])new ResultPartitionID[]{PARTITION_ID});
        Assertions.assertThat((boolean)table.hasTrackedPartitions((Object)JOB_ID)).isFalse();
    }

    @Test
    void testStopTrackingPartitions() {
        ResultPartitionID partitionId2 = new ResultPartitionID();
        PartitionTable table = new PartitionTable();
        table.startTrackingPartitions((Object)JOB_ID, Collections.singletonList(PARTITION_ID));
        table.startTrackingPartitions((Object)JOB_ID, Collections.singletonList(partitionId2));
        table.stopTrackingPartitions((Object)JOB_ID, Collections.singletonList(partitionId2));
        Assertions.assertThat((boolean)table.hasTrackedPartitions((Object)JOB_ID)).isTrue();
        Collection storedPartitions = table.stopTrackingPartitions((Object)JOB_ID);
        Assertions.assertThat((Collection)storedPartitions).contains((Object[])new ResultPartitionID[]{PARTITION_ID});
        Assertions.assertThat((boolean)table.hasTrackedPartitions((Object)JOB_ID)).isFalse();
    }
}

