/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor;

import java.time.Duration;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.api.java.tuple.Tuple6;
import org.apache.flink.runtime.blob.TransientBlobKey;
import org.apache.flink.runtime.checkpoint.CheckpointOptions;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.clusterframework.types.SlotID;
import org.apache.flink.runtime.deployment.TaskDeploymentDescriptor;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.PartitionInfo;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.jobmaster.AllocatedSlotReport;
import org.apache.flink.runtime.jobmaster.JobMasterId;
import org.apache.flink.runtime.messages.Acknowledge;
import org.apache.flink.runtime.messages.TaskThreadInfoResponse;
import org.apache.flink.runtime.operators.coordination.OperatorEvent;
import org.apache.flink.runtime.resourcemanager.ResourceManagerId;
import org.apache.flink.runtime.rest.messages.LogInfo;
import org.apache.flink.runtime.rest.messages.ProfilingInfo;
import org.apache.flink.runtime.rest.messages.ThreadDumpInfo;
import org.apache.flink.runtime.taskexecutor.FileType;
import org.apache.flink.runtime.taskexecutor.TaskExecutorGateway;
import org.apache.flink.runtime.webmonitor.threadinfo.ThreadInfoSamplesRequest;
import org.apache.flink.types.SerializableOptional;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.SerializedValue;
import org.apache.flink.util.concurrent.FutureUtils;
import org.apache.flink.util.function.QuadFunction;
import org.apache.flink.util.function.TriFunction;

public class TestingTaskExecutorGateway
implements TaskExecutorGateway {
    private final String address;
    private final String hostname;
    private final BiFunction<ResourceID, AllocatedSlotReport, CompletableFuture<Void>> heartbeatJobManagerFunction;
    private final BiConsumer<JobID, Throwable> disconnectJobManagerConsumer;
    private final BiFunction<TaskDeploymentDescriptor, JobMasterId, CompletableFuture<Acknowledge>> submitTaskConsumer;
    private final Function<Tuple6<SlotID, JobID, AllocationID, ResourceProfile, String, ResourceManagerId>, CompletableFuture<Acknowledge>> requestSlotFunction;
    private final BiFunction<AllocationID, Throwable, CompletableFuture<Acknowledge>> freeSlotFunction;
    private final Consumer<JobID> freeInactiveSlotsConsumer;
    private final Function<ResourceID, CompletableFuture<Void>> heartbeatResourceManagerFunction;
    private final Consumer<Exception> disconnectResourceManagerConsumer;
    private final Function<ExecutionAttemptID, CompletableFuture<Acknowledge>> cancelTaskFunction;
    private final Supplier<CompletableFuture<Boolean>> canBeReleasedSupplier;
    private BiConsumer<JobID, Set<ResultPartitionID>> releasePartitionsConsumer;
    private BiConsumer<JobID, Set<ResultPartitionID>> promotePartitionsConsumer;
    private final Consumer<Collection<IntermediateDataSetID>> releaseClusterPartitionsConsumer;
    private final TriFunction<ExecutionAttemptID, OperatorID, SerializedValue<OperatorEvent>, CompletableFuture<Acknowledge>> operatorEventHandler;
    private final Supplier<CompletableFuture<ThreadDumpInfo>> requestThreadDumpSupplier;
    private final Supplier<CompletableFuture<ProfilingInfo>> requestProfilingSupplier;
    private final Supplier<CompletableFuture<TaskThreadInfoResponse>> requestThreadInfoSamplesSupplier;
    private final QuadFunction<ExecutionAttemptID, Long, Long, CheckpointOptions, CompletableFuture<Acknowledge>> triggerCheckpointFunction;
    private final TriFunction<ExecutionAttemptID, Long, Long, CompletableFuture<Acknowledge>> confirmCheckpointFunction;

    TestingTaskExecutorGateway(String address, String hostname, BiFunction<ResourceID, AllocatedSlotReport, CompletableFuture<Void>> heartbeatJobManagerFunction, BiConsumer<JobID, Throwable> disconnectJobManagerConsumer, BiFunction<TaskDeploymentDescriptor, JobMasterId, CompletableFuture<Acknowledge>> submitTaskConsumer, Function<Tuple6<SlotID, JobID, AllocationID, ResourceProfile, String, ResourceManagerId>, CompletableFuture<Acknowledge>> requestSlotFunction, BiFunction<AllocationID, Throwable, CompletableFuture<Acknowledge>> freeSlotFunction, Consumer<JobID> freeInactiveSlotsConsumer, Function<ResourceID, CompletableFuture<Void>> heartbeatResourceManagerFunction, Consumer<Exception> disconnectResourceManagerConsumer, Function<ExecutionAttemptID, CompletableFuture<Acknowledge>> cancelTaskFunction, Supplier<CompletableFuture<Boolean>> canBeReleasedSupplier, BiConsumer<JobID, Set<ResultPartitionID>> releasePartitionsConsumer, BiConsumer<JobID, Set<ResultPartitionID>> promotePartitionsConsumer, Consumer<Collection<IntermediateDataSetID>> releaseClusterPartitionsConsumer, TriFunction<ExecutionAttemptID, OperatorID, SerializedValue<OperatorEvent>, CompletableFuture<Acknowledge>> operatorEventHandler, Supplier<CompletableFuture<ThreadDumpInfo>> requestThreadDumpSupplier, Supplier<CompletableFuture<ProfilingInfo>> requestProfilingSupplier, Supplier<CompletableFuture<TaskThreadInfoResponse>> requestThreadInfoSamplesSupplier, QuadFunction<ExecutionAttemptID, Long, Long, CheckpointOptions, CompletableFuture<Acknowledge>> triggerCheckpointFunction, TriFunction<ExecutionAttemptID, Long, Long, CompletableFuture<Acknowledge>> confirmCheckpointFunction) {
        this.address = (String)Preconditions.checkNotNull((Object)address);
        this.hostname = (String)Preconditions.checkNotNull((Object)hostname);
        this.heartbeatJobManagerFunction = (BiFunction)Preconditions.checkNotNull(heartbeatJobManagerFunction);
        this.disconnectJobManagerConsumer = (BiConsumer)Preconditions.checkNotNull(disconnectJobManagerConsumer);
        this.submitTaskConsumer = (BiFunction)Preconditions.checkNotNull(submitTaskConsumer);
        this.requestSlotFunction = (Function)Preconditions.checkNotNull(requestSlotFunction);
        this.freeSlotFunction = (BiFunction)Preconditions.checkNotNull(freeSlotFunction);
        this.freeInactiveSlotsConsumer = (Consumer)Preconditions.checkNotNull(freeInactiveSlotsConsumer);
        this.heartbeatResourceManagerFunction = heartbeatResourceManagerFunction;
        this.disconnectResourceManagerConsumer = disconnectResourceManagerConsumer;
        this.cancelTaskFunction = cancelTaskFunction;
        this.canBeReleasedSupplier = canBeReleasedSupplier;
        this.releasePartitionsConsumer = releasePartitionsConsumer;
        this.promotePartitionsConsumer = promotePartitionsConsumer;
        this.releaseClusterPartitionsConsumer = releaseClusterPartitionsConsumer;
        this.operatorEventHandler = operatorEventHandler;
        this.requestThreadDumpSupplier = requestThreadDumpSupplier;
        this.requestProfilingSupplier = requestProfilingSupplier;
        this.requestThreadInfoSamplesSupplier = requestThreadInfoSamplesSupplier;
        this.triggerCheckpointFunction = triggerCheckpointFunction;
        this.confirmCheckpointFunction = confirmCheckpointFunction;
    }

    public CompletableFuture<Acknowledge> requestSlot(SlotID slotId, JobID jobId, AllocationID allocationId, ResourceProfile resourceProfile, String targetAddress, ResourceManagerId resourceManagerId, Time timeout) {
        return this.requestSlotFunction.apply((Tuple6<SlotID, JobID, AllocationID, ResourceProfile, String, ResourceManagerId>)Tuple6.of((Object)slotId, (Object)jobId, (Object)allocationId, (Object)resourceProfile, (Object)targetAddress, (Object)resourceManagerId));
    }

    public CompletableFuture<Acknowledge> submitTask(TaskDeploymentDescriptor tdd, JobMasterId jobMasterId, Time timeout) {
        return this.submitTaskConsumer.apply(tdd, jobMasterId);
    }

    public CompletableFuture<Acknowledge> updatePartitions(ExecutionAttemptID executionAttemptID, Iterable<PartitionInfo> partitionInfos, Time timeout) {
        return CompletableFuture.completedFuture(Acknowledge.get());
    }

    public void releasePartitions(JobID jobId, Set<ResultPartitionID> partitionIds) {
        this.releasePartitionsConsumer.accept(jobId, partitionIds);
    }

    public CompletableFuture<Acknowledge> promotePartitions(JobID jobId, Set<ResultPartitionID> partitionIds) {
        this.promotePartitionsConsumer.accept(jobId, partitionIds);
        return CompletableFuture.completedFuture(Acknowledge.get());
    }

    public CompletableFuture<Acknowledge> releaseClusterPartitions(Collection<IntermediateDataSetID> dataSetsToRelease, Time timeout) {
        this.releaseClusterPartitionsConsumer.accept(dataSetsToRelease);
        return CompletableFuture.completedFuture(Acknowledge.get());
    }

    public CompletableFuture<Acknowledge> triggerCheckpoint(ExecutionAttemptID executionAttemptID, long checkpointID, long checkpointTimestamp, CheckpointOptions checkpointOptions) {
        return (CompletableFuture)this.triggerCheckpointFunction.apply((Object)executionAttemptID, (Object)checkpointID, (Object)checkpointTimestamp, (Object)checkpointOptions);
    }

    public CompletableFuture<Acknowledge> confirmCheckpoint(ExecutionAttemptID executionAttemptID, long checkpointId, long checkpointTimestamp, long lastSubsumedCheckpointId) {
        return (CompletableFuture)this.confirmCheckpointFunction.apply((Object)executionAttemptID, (Object)checkpointId, (Object)checkpointTimestamp);
    }

    public CompletableFuture<Acknowledge> abortCheckpoint(ExecutionAttemptID executionAttemptID, long checkpointId, long latestCompletedCheckpointId, long checkpointTimestamp) {
        return CompletableFuture.completedFuture(Acknowledge.get());
    }

    public CompletableFuture<Acknowledge> cancelTask(ExecutionAttemptID executionAttemptID, Time timeout) {
        return this.cancelTaskFunction.apply(executionAttemptID);
    }

    public CompletableFuture<Void> heartbeatFromJobManager(ResourceID heartbeatOrigin, AllocatedSlotReport allocatedSlotReport) {
        return this.heartbeatJobManagerFunction.apply(heartbeatOrigin, allocatedSlotReport);
    }

    public CompletableFuture<Void> heartbeatFromResourceManager(ResourceID heartbeatOrigin) {
        return this.heartbeatResourceManagerFunction.apply(heartbeatOrigin);
    }

    public void disconnectJobManager(JobID jobId, Exception cause) {
        this.disconnectJobManagerConsumer.accept(jobId, cause);
    }

    public void disconnectResourceManager(Exception cause) {
        this.disconnectResourceManagerConsumer.accept(cause);
    }

    public CompletableFuture<Acknowledge> freeSlot(AllocationID allocationId, Throwable cause, Time timeout) {
        return this.freeSlotFunction.apply(allocationId, cause);
    }

    public void freeInactiveSlots(JobID jobId, Time timeout) {
        this.freeInactiveSlotsConsumer.accept(jobId);
    }

    public CompletableFuture<TransientBlobKey> requestFileUploadByType(FileType fileType, Time timeout) {
        return FutureUtils.completedExceptionally((Throwable)new UnsupportedOperationException());
    }

    public CompletableFuture<TransientBlobKey> requestFileUploadByName(String fileName, Duration timeout) {
        return FutureUtils.completedExceptionally((Throwable)new UnsupportedOperationException());
    }

    public CompletableFuture<TransientBlobKey> requestFileUploadByNameAndType(String fileName, FileType fileType, Duration timeout) {
        return FutureUtils.completedExceptionally((Throwable)new UnsupportedOperationException());
    }

    public CompletableFuture<SerializableOptional<String>> requestMetricQueryServiceAddress(Time timeout) {
        return CompletableFuture.completedFuture(SerializableOptional.empty());
    }

    public CompletableFuture<Boolean> canBeReleased() {
        return this.canBeReleasedSupplier.get();
    }

    public CompletableFuture<Acknowledge> sendOperatorEventToTask(ExecutionAttemptID task, OperatorID operator, SerializedValue<OperatorEvent> evt) {
        return (CompletableFuture)this.operatorEventHandler.apply((Object)task, (Object)operator, evt);
    }

    public CompletableFuture<ThreadDumpInfo> requestThreadDump(Time timeout) {
        return this.requestThreadDumpSupplier.get();
    }

    public CompletableFuture<Acknowledge> updateDelegationTokens(ResourceManagerId resourceManagerId, byte[] tokens) {
        return CompletableFuture.completedFuture(Acknowledge.get());
    }

    public CompletableFuture<ProfilingInfo> requestProfiling(int duration, ProfilingInfo.ProfilingMode mode, Duration timeout) {
        return this.requestProfilingSupplier.get();
    }

    public CompletableFuture<Collection<ProfilingInfo>> requestProfilingList(Duration timeout) {
        return FutureUtils.completedExceptionally((Throwable)new UnsupportedOperationException());
    }

    public String getAddress() {
        return this.address;
    }

    public CompletableFuture<TaskThreadInfoResponse> requestThreadInfoSamples(Collection<ExecutionAttemptID> taskExecutionAttemptIds, ThreadInfoSamplesRequest requestParams, Time timeout) {
        return this.requestThreadInfoSamplesSupplier.get();
    }

    public String getHostname() {
        return this.hostname;
    }

    public CompletableFuture<Collection<LogInfo>> requestLogList(Time timeout) {
        return FutureUtils.completedExceptionally((Throwable)new UnsupportedOperationException());
    }
}

