/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor;

import java.io.File;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nullable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.blob.BlobCacheService;
import org.apache.flink.runtime.blob.NoOpTaskExecutorBlobService;
import org.apache.flink.runtime.blob.PermanentBlobService;
import org.apache.flink.runtime.blob.TaskExecutorBlobService;
import org.apache.flink.runtime.blob.VoidPermanentBlobService;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.entrypoint.WorkingDirectory;
import org.apache.flink.runtime.externalresource.ExternalResourceInfoProvider;
import org.apache.flink.runtime.heartbeat.HeartbeatServices;
import org.apache.flink.runtime.heartbeat.HeartbeatServicesImpl;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.io.network.partition.TaskExecutorPartitionTracker;
import org.apache.flink.runtime.io.network.partition.TestingTaskExecutorPartitionTracker;
import org.apache.flink.runtime.metrics.groups.TaskManagerMetricGroup;
import org.apache.flink.runtime.metrics.groups.UnregisteredMetricGroups;
import org.apache.flink.runtime.rest.util.NoOpFatalErrorHandler;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.security.token.DelegationTokenReceiverRepository;
import org.apache.flink.runtime.taskexecutor.TaskExecutor;
import org.apache.flink.runtime.taskexecutor.TaskExecutorResourceSpec;
import org.apache.flink.runtime.taskexecutor.TaskExecutorResourceUtils;
import org.apache.flink.runtime.taskexecutor.TaskManagerConfiguration;
import org.apache.flink.runtime.taskexecutor.TaskManagerServices;
import org.apache.flink.runtime.taskexecutor.TaskManagerServicesConfiguration;
import org.apache.flink.util.concurrent.Executors;
import org.apache.flink.util.concurrent.ScheduledExecutor;

public class TaskExecutorBuilder {
    private final RpcService rpcService;
    private final HighAvailabilityServices haServices;
    private ResourceID resourceId = ResourceID.generate();
    private Configuration configuration = new Configuration();
    @Nullable
    private TaskManagerConfiguration taskManagerConfiguration = null;
    @Nullable
    private TaskManagerServices taskManagerServices = null;
    private ExternalResourceInfoProvider externalResourceInfoProvider = ExternalResourceInfoProvider.NO_EXTERNAL_RESOURCES;
    private HeartbeatServices heartbeatServices = new HeartbeatServicesImpl(0x100000L, 0x100000L);
    private TaskManagerMetricGroup taskManagerMetricGroup = UnregisteredMetricGroups.createUnregisteredTaskManagerMetricGroup();
    @Nullable
    private String metricQueryServiceAddress = null;
    @Nullable
    private BlobCacheService taskExecutorBlobService = null;
    private FatalErrorHandler fatalErrorHandler = NoOpFatalErrorHandler.INSTANCE;
    private TaskExecutorPartitionTracker partitionTracker = new TestingTaskExecutorPartitionTracker();
    private final WorkingDirectory workingDirectory;

    private TaskExecutorBuilder(RpcService rpcService, HighAvailabilityServices haServices, WorkingDirectory workingDirectory) {
        this.rpcService = rpcService;
        this.haServices = haServices;
        this.workingDirectory = workingDirectory;
    }

    public TaskExecutorBuilder setConfiguration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public TaskExecutorBuilder setResourceId(ResourceID resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    public TaskExecutor build() throws Exception {
        TaskManagerServices resolvedTaskManagerServices;
        TaskExecutorResourceUtils.adjustForLocalExecution((Configuration)this.configuration);
        NoOpTaskExecutorBlobService resolvedTaskExecutorBlobService = this.taskExecutorBlobService == null ? NoOpTaskExecutorBlobService.INSTANCE : this.taskExecutorBlobService;
        TaskExecutorResourceSpec taskExecutorResourceSpec = TaskExecutorResourceUtils.resourceSpecFromConfigForLocalExecution((Configuration)this.configuration);
        TaskManagerConfiguration resolvedTaskManagerConfiguration = this.taskManagerConfiguration == null ? TaskManagerConfiguration.fromConfiguration((Configuration)this.configuration, (TaskExecutorResourceSpec)taskExecutorResourceSpec, (String)this.rpcService.getAddress(), (File)this.workingDirectory.getTmpDirectory()) : this.taskManagerConfiguration;
        if (this.taskManagerServices == null) {
            TaskManagerServicesConfiguration taskManagerServicesConfiguration = TaskManagerServicesConfiguration.fromConfiguration((Configuration)this.configuration, (ResourceID)this.resourceId, (String)this.rpcService.getAddress(), (boolean)true, (TaskExecutorResourceSpec)taskExecutorResourceSpec, (WorkingDirectory)this.workingDirectory);
            resolvedTaskManagerServices = TaskManagerServices.fromConfiguration((TaskManagerServicesConfiguration)taskManagerServicesConfiguration, (PermanentBlobService)VoidPermanentBlobService.INSTANCE, (MetricGroup)UnregisteredMetricGroups.createUnregisteredTaskManagerMetricGroup(), (ExecutorService)Executors.newDirectExecutorService(), (ScheduledExecutor)this.rpcService.getScheduledExecutor(), throwable -> {}, (WorkingDirectory)this.workingDirectory);
        } else {
            resolvedTaskManagerServices = this.taskManagerServices;
        }
        DelegationTokenReceiverRepository delegationTokenReceiverRepository = new DelegationTokenReceiverRepository(this.configuration, null);
        return new TaskExecutor(this.rpcService, resolvedTaskManagerConfiguration, this.haServices, resolvedTaskManagerServices, this.externalResourceInfoProvider, this.heartbeatServices, this.taskManagerMetricGroup, this.metricQueryServiceAddress, (TaskExecutorBlobService)resolvedTaskExecutorBlobService, this.fatalErrorHandler, this.partitionTracker, delegationTokenReceiverRepository);
    }

    public static TaskExecutorBuilder newBuilder(RpcService rpcService, HighAvailabilityServices highAvailabilityServices, WorkingDirectory workingDirectory) {
        return new TaskExecutorBuilder(rpcService, highAvailabilityServices, workingDirectory);
    }
}

